/*
 * Decompiled with CFR 0.152.
 */
package com.helger.as2servlet;

import com.helger.as2lib.util.http.IAS2HttpRequestDataProvider;
import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.http.HttpHeaderMap;
import com.helger.commons.io.stream.NonClosingInputStream;
import com.helger.commons.io.stream.StreamHelper;
import com.helger.web.scope.IRequestWebScope;
import java.io.InputStream;
import javax.annotation.Nonnull;
import javax.annotation.WillNotClose;
import javax.annotation.concurrent.Immutable;
import javax.servlet.ServletInputStream;

@Immutable
final class AS2HttpRequestDataProviderServletRequest
implements IAS2HttpRequestDataProvider {
    private final IRequestWebScope m_aRequestScope;
    private final ServletInputStream m_aRequestIS;

    public AS2HttpRequestDataProviderServletRequest(@Nonnull IRequestWebScope iRequestWebScope, @Nonnull @WillNotClose ServletInputStream servletInputStream) {
        ValueEnforcer.notNull((Object)iRequestWebScope, (String)"RequestScope");
        ValueEnforcer.notNull((Object)servletInputStream, (String)"RequestIS");
        this.m_aRequestScope = iRequestWebScope;
        this.m_aRequestIS = servletInputStream;
    }

    @Nonnull
    public InputStream getHttpInputStream() {
        return StreamHelper.getBuffered((InputStream)new NonClosingInputStream((InputStream)this.m_aRequestIS));
    }

    @Nonnull
    @Nonempty
    public String getHttpRequestMethod() {
        return this.m_aRequestScope.getHttpMethod().getName();
    }

    @Nonnull
    @Nonempty
    public String getHttpRequestUrl() {
        return this.m_aRequestScope.getRequestURIDecoded();
    }

    @Nonnull
    @Nonempty
    public String getHttpRequestVersion() {
        return this.m_aRequestScope.getHttpVersion().getName();
    }

    @Nonnull
    public HttpHeaderMap getHttpHeaderMap() {
        return this.m_aRequestScope.headers();
    }
}

