/*
 * Decompiled with CFR 0.152.
 */
package com.helger.as2servlet.util;

import com.helger.as2lib.cert.ICertificateFactory;
import com.helger.as2lib.exception.AS2Exception;
import com.helger.as2lib.partner.IPartnershipFactory;
import com.helger.as2lib.processor.IMessageProcessor;
import com.helger.as2lib.processor.module.IProcessorModule;
import com.helger.as2lib.session.AS2Session;
import com.helger.as2lib.session.IAS2Session;
import com.helger.as2lib.util.AS2XMLHelper;
import com.helger.commons.ValueEnforcer;
import com.helger.commons.io.file.FileHelper;
import com.helger.xml.microdom.IMicroDocument;
import com.helger.xml.microdom.IMicroElement;
import com.helger.xml.microdom.serialize.MicroReader;
import java.io.File;
import java.io.InputStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AS2ServletXMLSession
extends AS2Session {
    public static final String EL_CERTIFICATES = "certificates";
    public static final String EL_PROCESSOR = "processor";
    public static final String EL_PARTNERSHIPS = "partnerships";
    private static final Logger LOGGER = LoggerFactory.getLogger(AS2ServletXMLSession.class);
    private final File m_aConfigFile;
    private final String m_sBaseDirectory;

    public AS2ServletXMLSession(@Nonnull File file) throws AS2Exception {
        ValueEnforcer.notNull((Object)file, (String)"File");
        if (!file.exists()) {
            throw new AS2Exception("AS2ServletXMLSession configuration file '" + file.getAbsolutePath() + "' does not exist!");
        }
        this.m_aConfigFile = file;
        this.m_sBaseDirectory = file.getParentFile().getAbsolutePath();
        LOGGER.info("Loading AS2 configuration file '" + file.getAbsolutePath());
        this._load(FileHelper.getInputStream((File)file));
    }

    @Nonnull
    public final File getConfigFile() {
        return this.m_aConfigFile;
    }

    @Nonnull
    public final String getBaseDirectory() {
        return this.m_sBaseDirectory;
    }

    private void _loadCertificateFactory(@Nonnull IMicroElement iMicroElement) throws AS2Exception {
        LOGGER.info("Loading certificates");
        ICertificateFactory iCertificateFactory = (ICertificateFactory)AS2XMLHelper.createComponent((IMicroElement)iMicroElement, ICertificateFactory.class, (IAS2Session)this, (String)this.m_sBaseDirectory);
        this.setCertificateFactory(iCertificateFactory);
    }

    private void _loadPartnershipFactory(IMicroElement iMicroElement) throws AS2Exception {
        LOGGER.info("Loading partnerships");
        IPartnershipFactory iPartnershipFactory = (IPartnershipFactory)AS2XMLHelper.createComponent((IMicroElement)iMicroElement, IPartnershipFactory.class, (IAS2Session)this, (String)this.m_sBaseDirectory);
        this.setPartnershipFactory(iPartnershipFactory);
    }

    private void _loadProcessorModule(@Nonnull IMessageProcessor iMessageProcessor, @Nonnull IMicroElement iMicroElement) throws AS2Exception {
        IProcessorModule iProcessorModule = (IProcessorModule)AS2XMLHelper.createComponent((IMicroElement)iMicroElement, IProcessorModule.class, (IAS2Session)this, (String)this.m_sBaseDirectory);
        iMessageProcessor.addModule(iProcessorModule);
        LOGGER.info("  Loaded processor module " + iProcessorModule.getName());
    }

    private void _loadMessageProcessor(IMicroElement iMicroElement) throws AS2Exception {
        LOGGER.info("Loading message processor");
        IMessageProcessor iMessageProcessor = (IMessageProcessor)AS2XMLHelper.createComponent((IMicroElement)iMicroElement, IMessageProcessor.class, (IAS2Session)this, (String)this.m_sBaseDirectory);
        this.setMessageProcessor(iMessageProcessor);
        for (IMicroElement iMicroElement2 : iMicroElement.getAllChildElements("module")) {
            this._loadProcessorModule(iMessageProcessor, iMicroElement2);
        }
    }

    private void _load(@Nullable InputStream inputStream) throws AS2Exception {
        if (inputStream != null) {
            IMicroDocument iMicroDocument = MicroReader.readMicroXML((InputStream)inputStream);
            IMicroElement iMicroElement = iMicroDocument.getDocumentElement();
            for (IMicroElement iMicroElement2 : iMicroElement.getAllChildElements()) {
                String string = iMicroElement2.getTagName();
                if (string.equals(EL_CERTIFICATES)) {
                    this._loadCertificateFactory(iMicroElement2);
                    continue;
                }
                if (string.equals(EL_PROCESSOR)) {
                    this._loadMessageProcessor(iMicroElement2);
                    continue;
                }
                if (string.equals(EL_PARTNERSHIPS)) {
                    this._loadPartnershipFactory(iMicroElement2);
                    continue;
                }
                throw new AS2Exception("Undefined tag: " + string);
            }
        }
    }

    public void reloadConfiguration() throws AS2Exception {
        LOGGER.info("Loading AS2 configuration file '" + this.m_aConfigFile.getAbsolutePath());
        this.resetToDefault();
        this._load(FileHelper.getInputStream((File)this.m_aConfigFile));
    }
}

