/*
 * Decompiled with CFR 0.152.
 */
package com.helger.as2servlet;

import com.helger.as2lib.exception.AS2Exception;
import com.helger.as2lib.session.AS2Session;
import com.helger.as2servlet.AbstractAS2ReceiveXServletHandler;
import com.helger.as2servlet.util.AS2ServletXMLSession;
import com.helger.commons.annotation.OverrideOnDemand;
import com.helger.commons.collection.impl.ICommonsMap;
import com.helger.commons.string.StringHelper;
import java.io.File;
import java.io.IOException;
import javax.annotation.Nonnull;
import javax.servlet.ServletException;

public class AS2ReceiveXServletHandlerFileBasedConfig
extends AbstractAS2ReceiveXServletHandler {
    @Nonnull
    @OverrideOnDemand
    protected File getConfigurationFile(@Nonnull ICommonsMap<String, String> iCommonsMap) throws ServletException {
        String string = (String)iCommonsMap.get((Object)"as2-servlet-config-filename");
        if (StringHelper.hasNoText((String)string)) {
            throw new ServletException("Servlet Init-Parameter 'as2-servlet-config-filename' is missing or empty!");
        }
        try {
            return new File(string).getCanonicalFile();
        }
        catch (IOException iOException) {
            throw new ServletException("Failed to get the canonical file from '" + string + "'", (Throwable)iOException);
        }
    }

    @Override
    @Nonnull
    protected AS2Session createAS2Session(@Nonnull ICommonsMap<String, String> iCommonsMap) throws AS2Exception, ServletException {
        File file = this.getConfigurationFile(iCommonsMap);
        if (file == null) {
            throw new ServletException("No configuration file provided!");
        }
        return new AS2ServletXMLSession(file);
    }
}

