/*
 * Decompiled with CFR 0.152.
 */
package com.helger.as2servlet;

import com.helger.as2lib.exception.AS2Exception;
import com.helger.as2lib.message.AS2Message;
import com.helger.as2lib.message.IBaseMessage;
import com.helger.as2lib.processor.receiver.AS2ReceiverModule;
import com.helger.as2lib.processor.receiver.net.AS2ReceiverHandler;
import com.helger.as2lib.session.AS2Session;
import com.helger.as2lib.util.AS2HttpHelper;
import com.helger.as2lib.util.dump.IHTTPIncomingDumper;
import com.helger.as2lib.util.http.HTTPHelper;
import com.helger.as2lib.util.http.IAS2HttpResponseHandler;
import com.helger.as2servlet.util.AS2OutputStreamCreatorHttpServletResponse;
import com.helger.as2servlet.util.AS2ServletReceiverModule;
import com.helger.commons.annotation.OverrideOnDemand;
import com.helger.commons.collection.impl.ICommonsMap;
import com.helger.commons.http.EHttpMethod;
import com.helger.commons.io.stream.StreamHelper;
import com.helger.http.EHttpVersion;
import com.helger.mail.datasource.ByteArrayDataSource;
import com.helger.servlet.ServletHelper;
import com.helger.web.scope.IRequestWebScope;
import com.helger.xservlet.handler.IXServletHandler;
import java.io.DataInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import javax.activation.DataSource;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.OverridingMethodsMustInvokeSuper;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractAS2ReceiveXServletHandler
implements IXServletHandler {
    public static final String SERVLET_INIT_PARAM_AS2_SERVLET_CONFIG_FILENAME = "as2-servlet-config-filename";
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractAS2ReceiveXServletHandler.class);
    private AS2Session m_aSession;
    private AS2ReceiverModule m_aReceiver;
    private IHTTPIncomingDumper m_aHttpIncomingDumper;

    @Nonnull
    @OverrideOnDemand
    protected abstract AS2Session createAS2Session(@Nonnull ICommonsMap<String, String> var1) throws AS2Exception, ServletException;

    public void onServletInit(@Nonnull ICommonsMap<String, String> iCommonsMap) throws ServletException {
        try {
            this.m_aSession = this.createAS2Session(iCommonsMap);
            this.m_aReceiver = (AS2ReceiverModule)this.m_aSession.getMessageProcessor().getModuleOfClass(AS2ServletReceiverModule.class);
            if (this.m_aReceiver == null) {
                throw new ServletException("Failed to retrieve AS2ReceiverModule which is a mandatory module! Please ensure your configuration file contains at least the module '" + AS2ServletReceiverModule.class.getName() + "'");
            }
        }
        catch (AS2Exception aS2Exception) {
            throw new ServletException("Failed to init AS2 configuration", (Throwable)aS2Exception);
        }
        LOGGER.info("Successfully initialized AS2 configuration");
    }

    @Nonnull
    protected final AS2Session getSession() {
        if (this.m_aSession == null) {
            throw new IllegalStateException("This servlet was not initialized properly! No AS2 session is present.");
        }
        return this.m_aSession;
    }

    @Nonnull
    protected final AS2ReceiverModule getReceiverModule() {
        if (this.m_aReceiver == null) {
            throw new IllegalStateException("This servlet was not initialized properly! No receiver is present.");
        }
        return this.m_aReceiver;
    }

    @Nullable
    public final IHTTPIncomingDumper getHttpIncomingDumper() {
        return this.m_aHttpIncomingDumper;
    }

    @Nullable
    public final IHTTPIncomingDumper getEffectiveHttpIncomingDumper() {
        IHTTPIncomingDumper iHTTPIncomingDumper = this.m_aHttpIncomingDumper;
        if (iHTTPIncomingDumper == null) {
            iHTTPIncomingDumper = HTTPHelper.getHTTPIncomingDumper();
        }
        return iHTTPIncomingDumper;
    }

    public final void setHttpIncomingDumper(@Nullable IHTTPIncomingDumper iHTTPIncomingDumper) {
        this.m_aHttpIncomingDumper = iHTTPIncomingDumper;
    }

    @OverridingMethodsMustInvokeSuper
    @OverrideOnDemand
    protected void handeIncomingMessage(@Nonnull HttpServletRequest httpServletRequest, @Nonnull HttpServletResponse httpServletResponse, @Nonnull IRequestWebScope iRequestWebScope, @Nonnull byte[] byArray, @Nonnull AS2Message aS2Message, @Nonnull AS2OutputStreamCreatorHttpServletResponse aS2OutputStreamCreatorHttpServletResponse) throws ServletException {
        String string = httpServletRequest.getRemoteAddr() + ":" + httpServletRequest.getRemotePort();
        String string2 = AS2HttpHelper.getCleanContentType((String)aS2Message.getHeader("Content-Type"));
        if (string2 == null) {
            throw new ServletException("Incoming message does not contain a valid Content-Type: '" + aS2Message.getHeader("Content-Type") + "'");
        }
        ByteArrayDataSource byteArrayDataSource = new ByteArrayDataSource(byArray, string2, null);
        AS2ReceiverHandler aS2ReceiverHandler = this.getReceiverModule().createHandler();
        aS2ReceiverHandler.handleIncomingMessage(string, (DataSource)byteArrayDataSource, aS2Message, (IAS2HttpResponseHandler)aS2OutputStreamCreatorHttpServletResponse);
    }

    public final void onRequest(@Nonnull HttpServletRequest httpServletRequest, @Nonnull HttpServletResponse httpServletResponse, @Nonnull EHttpVersion eHttpVersion, @Nonnull EHttpMethod eHttpMethod, @Nonnull IRequestWebScope iRequestWebScope) throws ServletException, IOException {
        Object object;
        byte[] byArray;
        AS2Message aS2Message = new AS2Message();
        aS2Message.attrs().putIn((Object)"source_ip", (Object)httpServletRequest.getRemoteAddr());
        aS2Message.attrs().putIn("source_port", httpServletRequest.getRemotePort());
        aS2Message.attrs().putIn((Object)"destination_ip", (Object)httpServletRequest.getLocalAddr());
        aS2Message.attrs().putIn("destination_port", httpServletRequest.getLocalPort());
        aS2Message.attrs().putIn((Object)"HTTP_REQUEST_TYPE", (Object)httpServletRequest.getMethod());
        aS2Message.attrs().putIn((Object)"HTTP_REQUEST_URL", (Object)ServletHelper.getRequestRequestURI((HttpServletRequest)httpServletRequest));
        aS2Message.headers().setAllHeaders(iRequestWebScope.headers());
        boolean bl = this.getReceiverModule().isQuoteHeaderValues();
        AS2OutputStreamCreatorHttpServletResponse aS2OutputStreamCreatorHttpServletResponse = new AS2OutputStreamCreatorHttpServletResponse(httpServletResponse, bl);
        long l = httpServletRequest.getContentLengthLong();
        if (l > Integer.MAX_VALUE) {
            throw new IllegalStateException("Currently only payload with up to 2GB can be handled!");
        }
        if (l >= 0L) {
            byArray = new byte[(int)l];
            object = new DataInputStream((InputStream)httpServletRequest.getInputStream());
            Throwable throwable = null;
            try {
                ((DataInputStream)object).readFully(byArray);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (object != null) {
                    if (throwable != null) {
                        try {
                            ((FilterInputStream)object).close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        ((FilterInputStream)object).close();
                    }
                }
            }
        } else {
            byArray = StreamHelper.getAllBytes((InputStream)httpServletRequest.getInputStream());
        }
        if ((object = this.getEffectiveHttpIncomingDumper()) != null) {
            object.dumpIncomingRequest((List)aS2Message.headers().getAllHeaderLines(true), byArray, (IBaseMessage)aS2Message);
        }
        this.handeIncomingMessage(httpServletRequest, httpServletResponse, iRequestWebScope, byArray, aS2Message, aS2OutputStreamCreatorHttpServletResponse);
    }
}

