/*
 * Decompiled with CFR 0.152.
 */
package com.helger.as2servlet.util;

import com.helger.as2lib.util.http.IAS2HttpResponseHandler;
import com.helger.commons.ValueEnforcer;
import com.helger.commons.http.HttpHeaderMap;
import com.helger.commons.io.IWriteToStream;
import com.helger.commons.io.stream.StreamHelper;
import java.io.IOException;
import java.io.OutputStream;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.WillNotClose;
import javax.servlet.http.HttpServletResponse;

public class AS2OutputStreamCreatorHttpServletResponse
implements IAS2HttpResponseHandler {
    private final HttpServletResponse m_aHttpResponse;
    private final boolean m_bQuoteHeaderValues;

    public AS2OutputStreamCreatorHttpServletResponse(@Nonnull HttpServletResponse httpServletResponse, boolean bl) {
        this.m_aHttpResponse = (HttpServletResponse)ValueEnforcer.notNull((Object)httpServletResponse, (String)"HttpResponse");
        this.m_bQuoteHeaderValues = bl;
    }

    public final boolean isQuoteHeaderHeaderValues() {
        return this.m_bQuoteHeaderValues;
    }

    public void sendHttpResponse(@Nonnegative int n, @Nonnull HttpHeaderMap httpHeaderMap, @Nonnull @WillNotClose IWriteToStream iWriteToStream) throws IOException {
        this.m_aHttpResponse.setStatus(n);
        httpHeaderMap.forEachSingleHeader((string, string2) -> this.m_aHttpResponse.addHeader(string, string2), true, this.m_bQuoteHeaderValues);
        OutputStream outputStream = StreamHelper.getBuffered((OutputStream)this.m_aHttpResponse.getOutputStream());
        iWriteToStream.writeTo(outputStream);
        outputStream.flush();
    }
}

