/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.lang.priviledged;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.lang.priviledged.AccessControllerHelper;
import java.net.Authenticator;
import java.net.ProxySelector;
import java.security.PrivilegedAction;
import java.security.Provider;
import java.security.Security;
import java.util.Properties;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@FunctionalInterface
public interface IPrivilegedAction<T>
extends PrivilegedAction<T> {
    @Nullable
    default public T invokeSafe() {
        return IPrivilegedAction.invokeSafe(this);
    }

    @Nullable
    public static <T> T invokeSafe(@Nonnull IPrivilegedAction<T> iPrivilegedAction) {
        if (System.getSecurityManager() == null) {
            return iPrivilegedAction.run();
        }
        return AccessControllerHelper.call(iPrivilegedAction);
    }

    @Nonnull
    public static IPrivilegedAction<Void> asVoid(@Nonnull Runnable runnable) {
        return () -> {
            runnable.run();
            return null;
        };
    }

    @Nonnull
    public static IPrivilegedAction<ClassLoader> classLoaderGetParent(@Nonnull ClassLoader classLoader) {
        return classLoader::getParent;
    }

    @Nonnull
    public static IPrivilegedAction<ClassLoader> getClassLoader(@Nonnull Class<?> clazz) {
        return clazz::getClassLoader;
    }

    @Nonnull
    public static IPrivilegedAction<ClassLoader> getContextClassLoader() {
        return Thread.currentThread()::getContextClassLoader;
    }

    @Nonnull
    public static IPrivilegedAction<Void> setContextClassLoader(@Nonnull ClassLoader classLoader) {
        ValueEnforcer.notNull(classLoader, "ClassLoader");
        return IPrivilegedAction.asVoid(() -> Thread.currentThread().setContextClassLoader(classLoader));
    }

    @Nonnull
    public static IPrivilegedAction<ClassLoader> getSystemClassLoader() {
        return ClassLoader::getSystemClassLoader;
    }

    @Nonnull
    public static IPrivilegedAction<String> systemClearProperty(@Nonnull String string) {
        ValueEnforcer.notNull(string, "Key");
        return () -> System.clearProperty(string);
    }

    @Nonnull
    public static IPrivilegedAction<String> systemGetProperty(@Nonnull String string) {
        ValueEnforcer.notNull(string, "Key");
        return () -> System.getProperty(string);
    }

    @Nonnull
    public static IPrivilegedAction<Properties> systemGetProperties() {
        return System::getProperties;
    }

    @Nonnull
    public static IPrivilegedAction<String> systemSetProperty(@Nonnull String string, @Nonnull String string2) {
        ValueEnforcer.notNull(string, "Key");
        ValueEnforcer.notNull(string2, "Value");
        return () -> System.setProperty(string, string2);
    }

    @Nonnull
    public static IPrivilegedAction<ProxySelector> proxySelectorGetDefault() {
        return ProxySelector::getDefault;
    }

    @Nonnull
    public static IPrivilegedAction<Void> proxySelectorSetDefault(@Nullable ProxySelector proxySelector) {
        return IPrivilegedAction.asVoid(() -> ProxySelector.setDefault(proxySelector));
    }

    @Nonnull
    public static IPrivilegedAction<Void> authenticatorSetDefault(@Nullable Authenticator authenticator) {
        return IPrivilegedAction.asVoid(() -> Authenticator.setDefault(authenticator));
    }

    @Nonnull
    public static IPrivilegedAction<Provider[]> securityGetProviders() {
        return Security::getProviders;
    }

    @Nonnull
    public static IPrivilegedAction<Provider[]> securityGetProviders(@Nonnull String string) {
        ValueEnforcer.notNull(string, "Filter");
        return () -> Security.getProviders(string);
    }

    @Nonnull
    public static IPrivilegedAction<Provider> securityGetProvider(@Nonnull String string) {
        return () -> Security.getProvider(string);
    }

    @Nonnull
    public static IPrivilegedAction<Integer> securityAddProvider(@Nonnull Provider provider) {
        ValueEnforcer.notNull(provider, "Provider");
        return () -> Security.addProvider(provider);
    }

    @Nonnull
    public static IPrivilegedAction<Integer> securityInsertProviderAt(@Nonnull Provider provider, int n) {
        ValueEnforcer.notNull(provider, "Provider");
        return () -> Security.insertProviderAt(provider, n);
    }

    @Nonnull
    public static IPrivilegedAction<Void> securityRemoveProvider(@Nonnull String string) {
        return IPrivilegedAction.asVoid(() -> Security.removeProvider(string));
    }
}

