/*
 * Decompiled with CFR 0.152.
 */
package com.helger.jcodemodel;

import com.helger.jcodemodel.IJExpression;
import com.helger.jcodemodel.JFormatter;
import com.helger.jcodemodel.util.JCEqualsHelper;
import com.helger.jcodemodel.util.JCHashCodeGenerator;
import javax.annotation.Nonnull;

public class JAtomDouble
implements IJExpression {
    public static final String JAVA_LANG_DOUBLE_NEGATIVE_INFINITY = "java.lang.Double.NEGATIVE_INFINITY";
    public static final String JAVA_LANG_DOUBLE_POSITIVE_INFINITY = "java.lang.Double.POSITIVE_INFINITY";
    public static final String JAVA_LANG_DOUBLE_NAN = "java.lang.Double.NaN";
    private final double m_dWhat;

    protected JAtomDouble(double d) {
        this.m_dWhat = d;
    }

    public double what() {
        return this.m_dWhat;
    }

    @Override
    public void generate(@Nonnull JFormatter jFormatter) {
        if (this.m_dWhat == Double.NEGATIVE_INFINITY) {
            jFormatter.print(JAVA_LANG_DOUBLE_NEGATIVE_INFINITY);
        } else if (this.m_dWhat == Double.POSITIVE_INFINITY) {
            jFormatter.print(JAVA_LANG_DOUBLE_POSITIVE_INFINITY);
        } else if (Double.isNaN(this.m_dWhat)) {
            jFormatter.print(JAVA_LANG_DOUBLE_NAN);
        } else {
            jFormatter.print(Double.toString(this.m_dWhat));
        }
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        JAtomDouble jAtomDouble = (JAtomDouble)object;
        return JCEqualsHelper.isEqual(this.m_dWhat, jAtomDouble.m_dWhat);
    }

    public int hashCode() {
        return JCHashCodeGenerator.getHashCode(this, this.m_dWhat);
    }
}

