/*
 * Decompiled with CFR 0.152.
 */
package com.helger.jcodemodel;

import com.helger.jcodemodel.IJExpression;
import com.helger.jcodemodel.IJStatement;
import com.helger.jcodemodel.JBlock;
import com.helger.jcodemodel.JFormatter;
import com.helger.jcodemodel.JOp;
import com.helger.jcodemodel.util.JCValueEnforcer;
import javax.annotation.Nonnull;

public class JDoLoop
implements IJStatement {
    private final IJExpression m_aTest;
    private JBlock m_aBody;

    protected JDoLoop(@Nonnull IJExpression iJExpression) {
        this.m_aTest = JCValueEnforcer.notNull(iJExpression, "Test");
    }

    @Nonnull
    public IJExpression test() {
        return this.m_aTest;
    }

    @Nonnull
    public JBlock body() {
        if (this.m_aBody == null) {
            this.m_aBody = new JBlock();
        }
        return this.m_aBody;
    }

    @Override
    public void state(@Nonnull JFormatter jFormatter) {
        jFormatter.print("do");
        if (this.m_aBody != null) {
            jFormatter.generable(this.m_aBody);
        } else {
            jFormatter.print("{ }");
        }
        if (JOp.hasTopOp(this.m_aTest)) {
            jFormatter.print("while ").generable(this.m_aTest);
        } else {
            jFormatter.print("while (").generable(this.m_aTest).print(')');
        }
        jFormatter.print(';').newline();
    }
}

