/*
 * Decompiled with CFR 0.152.
 */
package com.helger.jcodemodel;

import com.helger.jcodemodel.IJExpression;
import com.helger.jcodemodel.IJStatement;
import com.helger.jcodemodel.JBlock;
import com.helger.jcodemodel.JFormatter;
import com.helger.jcodemodel.util.JCValueEnforcer;
import javax.annotation.Nonnull;

public class JSynchronizedBlock
implements IJStatement {
    private IJExpression m_aExpression;
    private JBlock m_aBody;

    protected JSynchronizedBlock(@Nonnull IJExpression iJExpression) {
        this.expr(iJExpression);
    }

    public final void expr(@Nonnull IJExpression iJExpression) {
        JCValueEnforcer.notNull(iJExpression, "expression");
        this.m_aExpression = iJExpression;
    }

    @Nonnull
    public IJExpression expr() {
        return this.m_aExpression;
    }

    @Nonnull
    public JBlock body() {
        if (this.m_aBody == null) {
            this.m_aBody = new JBlock();
        }
        return this.m_aBody;
    }

    @Override
    public void state(@Nonnull JFormatter jFormatter) {
        jFormatter.print("synchronized (").generable(this.m_aExpression).print(")").newline();
        if (this.m_aBody != null) {
            jFormatter.generable(this.m_aBody);
        } else {
            jFormatter.print("{}");
        }
        jFormatter.newline();
    }
}

