/*
 * Decompiled with CFR 0.152.
 */
package com.helger.jcodemodel.util;

import com.helger.jcodemodel.util.JCHashCodeCalculator;
import com.helger.jcodemodel.util.JCValueEnforcer;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import org.w3c.dom.Node;

@NotThreadSafe
public final class JCHashCodeGenerator {
    public static final int ILLEGAL_HASHCODE = 0;
    public static final int INITIAL_HASHCODE = 17;
    private boolean m_bClosed = false;
    private int m_nHC = 17;

    public JCHashCodeGenerator(@Nonnull Object object) {
        this(object instanceof Class ? (Class<?>)object : object.getClass());
    }

    public JCHashCodeGenerator(@Nonnull Class<?> clazz) {
        JCValueEnforcer.notNull(clazz, "Class");
        this.append(clazz.getName());
        Class<?> clazz2 = clazz.getComponentType();
        if (clazz2 != null) {
            this.append(clazz2.getName());
        }
    }

    private JCHashCodeGenerator(int n) {
        this.m_nHC = n;
    }

    private void _checkClosed() {
        if (this.m_bClosed) {
            throw new IllegalStateException("Hash code cannot be changed anymore!");
        }
    }

    @Nonnull
    public JCHashCodeGenerator append(boolean bl) {
        this._checkClosed();
        this.m_nHC = JCHashCodeCalculator.append(this.m_nHC, bl);
        return this;
    }

    @Nonnull
    public JCHashCodeGenerator append(byte by) {
        this._checkClosed();
        this.m_nHC = JCHashCodeCalculator.append(this.m_nHC, by);
        return this;
    }

    @Nonnull
    public JCHashCodeGenerator append(char c) {
        this._checkClosed();
        this.m_nHC = JCHashCodeCalculator.append(this.m_nHC, c);
        return this;
    }

    @Nonnull
    public JCHashCodeGenerator append(double d) {
        this._checkClosed();
        this.m_nHC = JCHashCodeCalculator.append(this.m_nHC, d);
        return this;
    }

    @Nonnull
    public JCHashCodeGenerator append(float f) {
        this._checkClosed();
        this.m_nHC = JCHashCodeCalculator.append(this.m_nHC, f);
        return this;
    }

    @Nonnull
    public JCHashCodeGenerator append(int n) {
        this._checkClosed();
        this.m_nHC = JCHashCodeCalculator.append(this.m_nHC, n);
        return this;
    }

    @Nonnull
    public JCHashCodeGenerator append(long l) {
        this._checkClosed();
        this.m_nHC = JCHashCodeCalculator.append(this.m_nHC, l);
        return this;
    }

    @Nonnull
    public JCHashCodeGenerator append(short s) {
        this._checkClosed();
        this.m_nHC = JCHashCodeCalculator.append(this.m_nHC, s);
        return this;
    }

    @Nonnull
    public JCHashCodeGenerator append(@Nullable Object object) {
        this._checkClosed();
        this.m_nHC = JCHashCodeCalculator.append(this.m_nHC, object);
        return this;
    }

    @Nonnull
    public JCHashCodeGenerator append(@Nullable Enum<?> enum_) {
        this._checkClosed();
        this.m_nHC = JCHashCodeCalculator.append(this.m_nHC, enum_);
        return this;
    }

    @Nonnull
    public JCHashCodeGenerator append(@Nullable boolean[] blArray) {
        this._checkClosed();
        this.m_nHC = JCHashCodeCalculator.append(this.m_nHC, blArray);
        return this;
    }

    @Nonnull
    public JCHashCodeGenerator append(@Nullable byte[] byArray) {
        this._checkClosed();
        this.m_nHC = JCHashCodeCalculator.append(this.m_nHC, byArray);
        return this;
    }

    @Nonnull
    public JCHashCodeGenerator append(@Nullable char[] cArray) {
        this._checkClosed();
        this.m_nHC = JCHashCodeCalculator.append(this.m_nHC, cArray);
        return this;
    }

    @Nonnull
    public JCHashCodeGenerator append(@Nullable double[] dArray) {
        this._checkClosed();
        this.m_nHC = JCHashCodeCalculator.append(this.m_nHC, dArray);
        return this;
    }

    @Nonnull
    public JCHashCodeGenerator append(@Nullable float[] fArray) {
        this._checkClosed();
        this.m_nHC = JCHashCodeCalculator.append(this.m_nHC, fArray);
        return this;
    }

    @Nonnull
    public JCHashCodeGenerator append(@Nullable int[] nArray) {
        this._checkClosed();
        this.m_nHC = JCHashCodeCalculator.append(this.m_nHC, nArray);
        return this;
    }

    @Nonnull
    public JCHashCodeGenerator append(@Nullable long[] lArray) {
        this._checkClosed();
        this.m_nHC = JCHashCodeCalculator.append(this.m_nHC, lArray);
        return this;
    }

    @Nonnull
    public JCHashCodeGenerator append(@Nullable short[] sArray) {
        this._checkClosed();
        this.m_nHC = JCHashCodeCalculator.append(this.m_nHC, sArray);
        return this;
    }

    @Nonnull
    public JCHashCodeGenerator append(@Nullable Object[] objectArray) {
        this._checkClosed();
        this.m_nHC = JCHashCodeCalculator.append(this.m_nHC, objectArray);
        return this;
    }

    @Nonnull
    public JCHashCodeGenerator append(@Nullable Enum<?>[] enumArray) {
        this._checkClosed();
        this.m_nHC = JCHashCodeCalculator.append(this.m_nHC, enumArray);
        return this;
    }

    @Nonnull
    public JCHashCodeGenerator append(@Nullable StringBuffer stringBuffer) {
        this._checkClosed();
        this.m_nHC = JCHashCodeCalculator.append(this.m_nHC, stringBuffer);
        return this;
    }

    @Nonnull
    public JCHashCodeGenerator append(@Nullable StringBuilder stringBuilder) {
        this._checkClosed();
        this.m_nHC = JCHashCodeCalculator.append(this.m_nHC, stringBuilder);
        return this;
    }

    @Nonnull
    public JCHashCodeGenerator append(@Nullable Iterable<?> iterable) {
        this._checkClosed();
        this.m_nHC = JCHashCodeCalculator.append(this.m_nHC, iterable);
        return this;
    }

    @Nonnull
    public JCHashCodeGenerator append(@Nullable Map<?, ?> map) {
        this._checkClosed();
        this.m_nHC = JCHashCodeCalculator.append(this.m_nHC, map);
        return this;
    }

    @Nonnull
    public JCHashCodeGenerator append(@Nullable Node node) {
        this._checkClosed();
        this.m_nHC = JCHashCodeCalculator.append(this.m_nHC, node);
        return this;
    }

    public int getHashCode() {
        this.m_bClosed = true;
        if (this.m_nHC == 0) {
            this.m_nHC = -1;
        }
        return this.m_nHC;
    }

    @Nonnull
    public Integer getHashCodeObj() {
        return this.getHashCode();
    }

    @Deprecated
    public boolean equals(Object object) {
        return object == this;
    }

    @Deprecated
    public int hashCode() {
        return this.getHashCode();
    }

    @Nonnull
    public static JCHashCodeGenerator getDerived(int n) {
        if (n == 0) {
            throw new IllegalArgumentException("Passed hash code is invalid!");
        }
        return new JCHashCodeGenerator(n);
    }

    public static int getHashCode(@Nonnull Object object, Object ... objectArray) {
        JCHashCodeGenerator jCHashCodeGenerator = new JCHashCodeGenerator(object);
        if (objectArray != null) {
            for (Object object2 : objectArray) {
                jCHashCodeGenerator.append(object2);
            }
        }
        return jCHashCodeGenerator.getHashCode();
    }

    public static int getHashCode(@Nonnull int n, Object ... objectArray) {
        JCHashCodeGenerator jCHashCodeGenerator = JCHashCodeGenerator.getDerived(n);
        if (objectArray != null) {
            for (Object object : objectArray) {
                jCHashCodeGenerator.append(object);
            }
        }
        return jCHashCodeGenerator.getHashCode();
    }
}

