/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.codec;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.charset.CharsetHelper;
import com.helger.commons.codec.DecodeException;
import com.helger.commons.codec.ICodec;
import com.helger.commons.serialize.convert.SerializationConverter;
import com.helger.commons.string.StringHelper;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class AbstractRFC1522Codec
implements ICodec<String> {
    protected static final char SEP = '?';
    protected static final String PREFIX = "=?";
    protected static final String POSTFIX = "?=";
    private transient Charset m_aCharset;

    protected AbstractRFC1522Codec(@Nonnull Charset charset) {
        this.m_aCharset = ValueEnforcer.notNull(charset, "Charset");
    }

    private void writeObject(@Nonnull ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        SerializationConverter.writeConvertedObject(this.m_aCharset, objectOutputStream);
    }

    private void readObject(@Nonnull ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.m_aCharset = SerializationConverter.readConvertedObject(objectInputStream, Charset.class);
    }

    @Nonnull
    public Charset getCharset() {
        return this.m_aCharset;
    }

    @Nonnull
    @Nonempty
    protected abstract String getRFC1522Encoding();

    @Nullable
    @ReturnsMutableCopy
    protected abstract byte[] getEncoded(@Nullable byte[] var1, @Nonnegative int var2, @Nonnegative int var3);

    @Nullable
    @ReturnsMutableCopy
    protected abstract byte[] getDecoded(@Nullable byte[] var1, @Nonnegative int var2, @Nonnegative int var3);

    @Override
    @Nullable
    public String getEncoded(@Nullable String string) {
        if (string == null) {
            return null;
        }
        byte[] byArray = string.getBytes(this.m_aCharset);
        byte[] byArray2 = this.getEncoded(byArray, 0, byArray.length);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(PREFIX).append(this.m_aCharset.name()).append('?').append(this.getRFC1522Encoding()).append('?').append(StringHelper.decodeBytesToChars(byArray2, StandardCharsets.US_ASCII)).append(POSTFIX);
        return stringBuilder.toString();
    }

    @Override
    @Nullable
    public String getDecoded(@Nullable String string) {
        if (string == null) {
            return null;
        }
        ValueEnforcer.isTrue(string.startsWith(PREFIX), "RFC 1522 violation: malformed encoded content. Prefix missing.");
        ValueEnforcer.isTrue(string.endsWith(POSTFIX), "RFC 1522 violation: malformed encoded content. Postfix missing.");
        int n = PREFIX.length();
        int n2 = string.length() - POSTFIX.length();
        int n3 = string.indexOf(63, n);
        if (n3 == n2) {
            throw new DecodeException("RFC 1522 violation: charset token not found");
        }
        String string2 = string.substring(n, n3);
        if (StringHelper.hasNoText(string2)) {
            throw new DecodeException("RFC 1522 violation: charset not specified");
        }
        Charset charset = CharsetHelper.getCharsetFromNameOrNull(string2);
        if (charset == null) {
            throw new DecodeException("Failed to resolve charset '" + string2 + "'");
        }
        n = n3 + 1;
        if ((n3 = string.indexOf(63, n)) == n2) {
            throw new DecodeException("RFC 1522 violation: encoding token not found");
        }
        String string3 = string.substring(n, n3);
        if (!this.getRFC1522Encoding().equalsIgnoreCase(string3)) {
            throw new DecodeException("This codec cannot decode '" + string3 + "' encoded content");
        }
        n = n3 + 1;
        n3 = string.indexOf(63, n);
        byte[] byArray = string.substring(n, n3).getBytes(StandardCharsets.US_ASCII);
        byte[] byArray2 = this.getDecoded(byArray, 0, byArray.length);
        return new String(byArray2, charset);
    }
}

