/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.io.streamprovider;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.ArrayHelper;
import com.helger.commons.io.IHasInputStreamAndReader;
import com.helger.commons.io.stream.NonBlockingByteArrayInputStream;
import com.helger.commons.string.ToStringGenerator;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.InputStream;
import java.io.Serializable;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;

public class ByteArrayInputStreamProvider
implements IHasInputStreamAndReader,
Serializable {
    private final byte[] m_aData;
    private final int m_nOfs;
    private final int m_nLen;

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"})
    public ByteArrayInputStreamProvider(@Nonnull byte[] byArray) {
        ValueEnforcer.notNull(byArray, "Data");
        this.m_aData = byArray;
        this.m_nOfs = 0;
        this.m_nLen = byArray.length;
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"})
    public ByteArrayInputStreamProvider(@Nonnull byte[] byArray, @Nonnegative int n, @Nonnegative int n2) {
        ValueEnforcer.isArrayOfsLen(byArray, n, n2);
        this.m_aData = byArray;
        this.m_nOfs = n;
        this.m_nLen = n2;
    }

    @Nonnull
    @ReturnsMutableCopy
    public final byte[] getData() {
        return ArrayHelper.getCopy(this.m_aData);
    }

    @Nonnegative
    public final int getOffset() {
        return this.m_nOfs;
    }

    @Nonnegative
    public final int getLength() {
        return this.m_nLen;
    }

    @Override
    @Nonnull
    public final InputStream getInputStream() {
        return new NonBlockingByteArrayInputStream(this.m_aData, this.m_nOfs, this.m_nLen);
    }

    @Override
    public final boolean isReadMultiple() {
        return true;
    }

    public String toString() {
        return new ToStringGenerator(null).append("byteArray[]", this.m_aData.length + " bytes").append("ofs", this.m_nOfs).append("len", this.m_nLen).getToString();
    }
}

