/*
 * Decompiled with CFR 0.152.
 */
package com.helger.http.basicauth;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.string.ToStringGenerator;
import com.helger.http.HttpStringHelper;
import java.io.Serializable;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class BasicAuthServerBuilder
implements Serializable {
    private String m_sRealm;

    @Nonnull
    public BasicAuthServerBuilder setRealm(@Nonnull String string) {
        ValueEnforcer.isTrue((boolean)HttpStringHelper.isQuotedTextContent(string), () -> "Realm is invalid: " + string);
        this.m_sRealm = string;
        return this;
    }

    public boolean isValid() {
        return this.m_sRealm != null;
    }

    @Nonnull
    @Nonempty
    public String build() {
        if (!this.isValid()) {
            throw new IllegalStateException("Built Basic auth is not valid!");
        }
        StringBuilder stringBuilder = new StringBuilder("Basic");
        if (this.m_sRealm != null) {
            stringBuilder.append(" realm=").append(HttpStringHelper.getQuotedTextString(this.m_sRealm));
        }
        return stringBuilder.toString();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("realm", (Object)this.m_sRealm).getToString();
    }
}

