/*
 * Decompiled with CFR 0.152.
 */
package com.helger.http.csp;

import com.helger.commons.annotation.Nonempty;
import com.helger.commons.name.IHasName;
import com.helger.commons.string.StringHelper;
import java.io.Serializable;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public interface ICSPDirective
extends IHasName,
Serializable {
    @Nonnull
    @Nonempty
    public String getName();

    @Nullable
    public String getValue();

    default public boolean hasValue() {
        return StringHelper.hasText((String)this.getValue());
    }

    @Nonnull
    @Nonempty
    default public String getAsString() {
        return StringHelper.getConcatenatedOnDemand((String)this.getName(), (char)' ', (String)this.getValue());
    }

    @Nullable
    default public String getAsStringIfHasValue() {
        String string = this.getValue();
        if (StringHelper.hasText((String)string)) {
            return this.getName() + ' ' + string;
        }
        return null;
    }
}

