/*
 * Decompiled with CFR 0.152.
 */
package com.helger.http.digestauth;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.StringParser;
import com.helger.commons.string.ToStringGenerator;
import com.helger.http.HttpStringHelper;
import com.helger.http.digestauth.HttpDigestAuth;
import java.io.Serializable;
import javax.annotation.CheckForSigned;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public class DigestAuthClientCredentials
implements Serializable {
    public static final int EXPECTED_RESPONSE_LENGTH = 32;
    public static final int EXPECTED_NONCE_COUNT_LENGTH = 8;
    private final String m_sUserName;
    private final String m_sRealm;
    private final String m_sServerNonce;
    private final String m_sDigestURI;
    private final String m_sResponse;
    private final String m_sAlgorithm;
    private final String m_sClientNonce;
    private final String m_sOpaque;
    private final String m_sMessageQOP;
    private final int m_nNonceCount;

    public DigestAuthClientCredentials(@Nonnull @Nonempty String string, @Nonnull @Nonempty String string2, @Nonnull @Nonempty String string3, @Nonnull @Nonempty String string4, @Nonnull @Nonempty String string5, @Nullable String string6, @Nullable String string7, @Nullable String string8, @Nullable String string9, @Nullable String string10) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"UserName");
        ValueEnforcer.notEmpty((CharSequence)string2, (String)"Realm");
        ValueEnforcer.notEmpty((CharSequence)string3, (String)"ServerNonce");
        ValueEnforcer.notEmpty((CharSequence)string4, (String)"DigestURI");
        ValueEnforcer.notEmpty((CharSequence)string5, (String)"Response");
        if (string5.length() != 32) {
            throw new IllegalArgumentException("The 'response' value must be a 32-byte hex string!");
        }
        if (!HttpStringHelper.isLowerHexNotEmpty(string5)) {
            throw new IllegalArgumentException("The 'response' value must consist of all lowercase hex chars!");
        }
        if (StringHelper.hasText((String)string9) && StringHelper.hasNoText((String)string7)) {
            throw new IllegalArgumentException("If 'qop' is present 'cnonce' must also be present!");
        }
        if (StringHelper.hasNoText((String)string9) && StringHelper.hasText((String)string7)) {
            throw new IllegalArgumentException("If 'qop' is not present 'cnonce' must also not be present!");
        }
        if (StringHelper.hasText((String)string9) && StringHelper.hasNoText((String)string10)) {
            throw new IllegalArgumentException("If 'qop' is present 'nc' must also be present!");
        }
        if (StringHelper.hasNoText((String)string9) && StringHelper.hasText((String)string10)) {
            throw new IllegalArgumentException("If 'qop' is not present 'nc' must also not be present!");
        }
        if (string10 != null && string10.length() != 8) {
            throw new IllegalArgumentException("The 'nonce-count' value must be a 8-byte hex string!");
        }
        if (string10 != null && !HttpStringHelper.isHexNotEmpty(string10)) {
            throw new IllegalArgumentException("The 'nonce-count' value must consist only of hex chars!");
        }
        this.m_sUserName = string;
        this.m_sRealm = string2;
        this.m_sServerNonce = string3;
        this.m_sDigestURI = string4;
        this.m_sResponse = string5;
        this.m_sAlgorithm = string6;
        this.m_sClientNonce = string7;
        this.m_sOpaque = string8;
        this.m_sMessageQOP = string9;
        int n = this.m_nNonceCount = string10 == null ? -1 : StringParser.parseInt((String)string10, (int)16, (int)-1);
        if (string10 != null && this.m_nNonceCount == -1) {
            throw new IllegalArgumentException("The 'nonce-count' parameter is invalid: '" + string10 + "'");
        }
    }

    @Nonnull
    @Nonempty
    public String getUserName() {
        return this.m_sUserName;
    }

    @Nonnull
    @Nonempty
    public String getRealm() {
        return this.m_sRealm;
    }

    @Nonnull
    @Nonempty
    public String getServerNonce() {
        return this.m_sServerNonce;
    }

    @Nonnull
    @Nonempty
    public String getDigestURI() {
        return this.m_sDigestURI;
    }

    @Nullable
    public String getResponse() {
        return this.m_sResponse;
    }

    @Nullable
    public String getAlgorithm() {
        return this.m_sAlgorithm;
    }

    @Nullable
    public String getClientNonce() {
        return this.m_sClientNonce;
    }

    @Nullable
    public String getOpaque() {
        return this.m_sOpaque;
    }

    @Nullable
    public String getMessageQOP() {
        return this.m_sMessageQOP;
    }

    @CheckForSigned
    public int getNonceCount() {
        return this.m_nNonceCount;
    }

    @Nonnull
    @Nonempty
    public String getRequestValue() {
        StringBuilder stringBuilder = new StringBuilder("Digest");
        stringBuilder.append(" username=").append(HttpStringHelper.getQuotedTextString(this.m_sUserName)).append(", realm=").append(HttpStringHelper.getQuotedTextString(this.m_sRealm)).append(", nonce=").append(HttpStringHelper.getQuotedTextString(this.m_sServerNonce)).append(", uri=").append(HttpStringHelper.getQuotedTextString(this.m_sDigestURI)).append(", response=").append(HttpStringHelper.getQuotedTextString(this.m_sResponse));
        if (this.m_sAlgorithm != null) {
            stringBuilder.append(", algorithm=").append(this.m_sAlgorithm);
        }
        if (this.m_sClientNonce != null) {
            stringBuilder.append(", cnonce=").append(HttpStringHelper.getQuotedTextString(this.m_sClientNonce));
        }
        if (this.m_sOpaque != null) {
            stringBuilder.append(", opaque=").append(HttpStringHelper.getQuotedTextString(this.m_sOpaque));
        }
        if (this.m_sMessageQOP != null) {
            stringBuilder.append(", qop=").append(this.m_sMessageQOP);
        }
        if (this.m_nNonceCount > 0) {
            stringBuilder.append(", nc=").append(HttpDigestAuth.getNonceCountString(this.m_nNonceCount));
        }
        return stringBuilder.toString();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        DigestAuthClientCredentials digestAuthClientCredentials = (DigestAuthClientCredentials)object;
        return this.m_sUserName.equals(digestAuthClientCredentials.m_sUserName) && this.m_sRealm.equals(digestAuthClientCredentials.m_sRealm) && this.m_sServerNonce.equals(digestAuthClientCredentials.m_sServerNonce) && this.m_sDigestURI.equals(digestAuthClientCredentials.m_sDigestURI) && this.m_sResponse.equals(digestAuthClientCredentials.m_sResponse) && EqualsHelper.equals((Object)this.m_sAlgorithm, (Object)digestAuthClientCredentials.m_sAlgorithm) && EqualsHelper.equals((Object)this.m_sClientNonce, (Object)digestAuthClientCredentials.m_sClientNonce) && EqualsHelper.equals((Object)this.m_sOpaque, (Object)digestAuthClientCredentials.m_sOpaque) && EqualsHelper.equals((Object)this.m_sMessageQOP, (Object)digestAuthClientCredentials.m_sMessageQOP) && this.m_nNonceCount == digestAuthClientCredentials.m_nNonceCount;
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object)this.m_sUserName).append((Object)this.m_sRealm).append((Object)this.m_sServerNonce).append((Object)this.m_sDigestURI).append((Object)this.m_sResponse).append((Object)this.m_sAlgorithm).append((Object)this.m_sClientNonce).append((Object)this.m_sOpaque).append((Object)this.m_sMessageQOP).append(this.m_nNonceCount).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("userName", (Object)this.m_sUserName).append("realm", (Object)this.m_sRealm).append("serverNonce", (Object)this.m_sServerNonce).append("digestUri", (Object)this.m_sDigestURI).append("response", (Object)this.m_sResponse).appendIfNotNull("algorithm", (Object)this.m_sAlgorithm).appendIfNotNull("clientNonce", (Object)this.m_sClientNonce).appendIfNotNull("opaque", (Object)this.m_sOpaque).appendIfNotNull("messageQop", (Object)this.m_sMessageQOP).append("noncecount", this.m_nNonceCount).getToString();
    }
}

