/*
 * Decompiled with CFR 0.152.
 */
package com.helger.http.digestauth;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.collection.impl.CommonsLinkedHashSet;
import com.helger.commons.collection.impl.ICommonsOrderedSet;
import com.helger.commons.state.ETriState;
import com.helger.commons.string.StringHelper;
import com.helger.commons.url.ISimpleURL;
import com.helger.http.HttpStringHelper;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class DigestAuthServerBuilder {
    private String m_sRealm;
    private final ICommonsOrderedSet<String> m_aDomains = new CommonsLinkedHashSet();
    private String m_sNonce;
    private String m_sOpaque;
    private ETriState m_eStale = ETriState.UNDEFINED;
    private String m_sAlgorithm;
    private final ICommonsOrderedSet<String> m_aQOPs = new CommonsLinkedHashSet();

    @Nonnull
    public DigestAuthServerBuilder setRealm(@Nonnull String string) {
        if (!HttpStringHelper.isQuotedTextContent(string)) {
            throw new IllegalArgumentException("realm is invalid: " + string);
        }
        this.m_sRealm = string;
        return this;
    }

    @Nonnull
    public DigestAuthServerBuilder addDomain(@Nonnull ISimpleURL iSimpleURL) {
        ValueEnforcer.notNull((Object)iSimpleURL, (String)"Url");
        String string = iSimpleURL.getAsStringWithEncodedParameters();
        if (string.indexOf(32) >= 0) {
            throw new IllegalArgumentException("URL may not contain spaces: '" + string + "'");
        }
        this.m_aDomains.add((Object)string);
        return this;
    }

    @Nonnull
    public DigestAuthServerBuilder setNonce(@Nonnull String string) {
        if (!HttpStringHelper.isQuotedTextContent(string)) {
            throw new IllegalArgumentException("nonce is invalid: " + string);
        }
        this.m_sNonce = string;
        return this;
    }

    @Nonnull
    public DigestAuthServerBuilder setOpaque(@Nonnull String string) {
        if (!HttpStringHelper.isQuotedTextContent(string)) {
            throw new IllegalArgumentException("opaque is invalid: " + string);
        }
        this.m_sOpaque = string;
        return this;
    }

    @Nonnull
    public DigestAuthServerBuilder setStale(@Nonnull ETriState eTriState) {
        this.m_eStale = (ETriState)ValueEnforcer.notNull((Object)eTriState, (String)"Stale");
        return this;
    }

    @Nonnull
    public DigestAuthServerBuilder setAlgorithm(@Nonnull String string) {
        if (!HttpStringHelper.isToken(string)) {
            throw new IllegalArgumentException("The passed algorithm is not a valid token: " + string);
        }
        this.m_sAlgorithm = string;
        return this;
    }

    @Nonnull
    public DigestAuthServerBuilder addQOP(@Nonnull String string) {
        if (!HttpStringHelper.isToken(string)) {
            throw new IllegalArgumentException("The passed qop-option is not a token: " + string);
        }
        this.m_aQOPs.add((Object)string);
        return this;
    }

    public boolean isValid() {
        return this.m_sRealm != null && this.m_sNonce != null;
    }

    @Nonnull
    @Nonempty
    public String build() {
        if (!this.isValid()) {
            throw new IllegalStateException("Built Digest auth is not valid!");
        }
        StringBuilder stringBuilder = new StringBuilder("Digest");
        stringBuilder.append(" realm=").append(HttpStringHelper.getQuotedTextString(this.m_sRealm));
        if (this.m_aDomains.isNotEmpty()) {
            stringBuilder.append(", domain=").append(HttpStringHelper.getQuotedTextString(StringHelper.getImploded((char)' ', this.m_aDomains)));
        }
        stringBuilder.append(", nonce=").append(HttpStringHelper.getQuotedTextString(this.m_sNonce));
        if (this.m_sOpaque != null) {
            stringBuilder.append(", opaque=").append(HttpStringHelper.getQuotedTextString(this.m_sOpaque));
        }
        if (this.m_eStale.isDefined()) {
            stringBuilder.append(", stale=").append(this.m_eStale.isTrue() ? "true" : "false");
        }
        if (this.m_sAlgorithm != null) {
            stringBuilder.append(", algorithm=").append(this.m_sAlgorithm);
        }
        if (this.m_aQOPs.isNotEmpty()) {
            stringBuilder.append(", qop=").append(HttpStringHelper.getQuotedTextString(StringHelper.getImploded((char)',', this.m_aQOPs)));
        }
        return stringBuilder.toString();
    }
}

