/*
 * Decompiled with CFR 0.152.
 */
package com.helger.mail.cte;

import com.helger.commons.annotation.Nonempty;
import com.helger.commons.codec.Base64Codec;
import com.helger.commons.codec.IdentityByteArrayCodec;
import com.helger.commons.codec.QuotedPrintableCodec;
import com.helger.commons.codec.RFC1522QCodec;
import com.helger.commons.lang.EnumHelper;
import com.helger.mail.cte.IContentTransferEncoding;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public enum EContentTransferEncoding implements IContentTransferEncoding
{
    _7BIT("7bit"){

        public IdentityByteArrayCodec createCodec() {
            return IdentityByteArrayCodec.INSTANCE;
        }
    }
    ,
    _8BIT("8bit"){

        public IdentityByteArrayCodec createCodec() {
            return IdentityByteArrayCodec.INSTANCE;
        }
    }
    ,
    BINARY("binary"){

        public IdentityByteArrayCodec createCodec() {
            return IdentityByteArrayCodec.INSTANCE;
        }
    }
    ,
    QUOTED_PRINTABLE("quoted-printable"){

        public QuotedPrintableCodec createCodec() {
            return new QuotedPrintableCodec(RFC1522QCodec.getAllPrintableChars());
        }
    }
    ,
    BASE64("base64"){

        public Base64Codec createCodec() {
            return new Base64Codec();
        }
    };

    public static final EContentTransferEncoding AS2_DEFAULT;
    private final String m_sID;

    private EContentTransferEncoding(String string2) {
        this.m_sID = string2;
    }

    @Nonnull
    @Nonempty
    public String getID() {
        return this.m_sID;
    }

    @Nullable
    public static EContentTransferEncoding getFromIDCaseInsensitiveOrNull(@Nullable String string) {
        return (EContentTransferEncoding)EnumHelper.getFromIDCaseInsensitiveOrNull(EContentTransferEncoding.class, (String)string);
    }

    @Nullable
    public static EContentTransferEncoding getFromIDCaseInsensitiveOrDefault(@Nullable String string, @Nullable EContentTransferEncoding eContentTransferEncoding) {
        return (EContentTransferEncoding)EnumHelper.getFromIDCaseInsensitiveOrDefault(EContentTransferEncoding.class, (String)string, (Enum)eContentTransferEncoding);
    }

    static {
        AS2_DEFAULT = BINARY;
    }
}

