/*
 * Decompiled with CFR 0.152.
 */
package com.helger.servlet.response;

import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.http.HttpHeaderMap;
import java.io.IOException;
import javax.annotation.Nonnull;
import javax.annotation.OverridingMethodsMustInvokeSuper;
import javax.annotation.concurrent.NotThreadSafe;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;

@NotThreadSafe
public class StatusAwareHttpResponseWrapper
extends HttpServletResponseWrapper {
    private final HttpHeaderMap m_aHeaderMap = new HttpHeaderMap();
    private int m_nStatusCode = 200;

    public StatusAwareHttpResponseWrapper(@Nonnull HttpServletResponse httpServletResponse) {
        super(httpServletResponse);
    }

    @OverridingMethodsMustInvokeSuper
    public void setStatus(int n) {
        super.setStatus(n);
        this.m_nStatusCode = n;
    }

    @Deprecated
    @OverridingMethodsMustInvokeSuper
    public void setStatus(int n, String string) {
        super.setStatus(n, string);
        this.m_nStatusCode = n;
    }

    @OverridingMethodsMustInvokeSuper
    public void sendError(int n, String string) throws IOException {
        super.sendError(n, string);
        this.m_nStatusCode = n;
    }

    @OverridingMethodsMustInvokeSuper
    public void sendError(int n) throws IOException {
        super.sendError(n);
        this.m_nStatusCode = n;
    }

    @OverridingMethodsMustInvokeSuper
    public void sendRedirect(String string) throws IOException {
        super.sendRedirect(string);
        this.m_nStatusCode = 302;
    }

    public final int getStatusCode() {
        return this.m_nStatusCode;
    }

    public void reset() {
        super.reset();
        this.m_aHeaderMap.removeAll();
    }

    public void setContentLength(int n) {
        super.setContentLength(n);
        this.m_aHeaderMap.setContentLength((long)n);
    }

    public void setContentType(@Nonnull String string) {
        super.setContentType(string);
        this.m_aHeaderMap.setContentType(string);
    }

    public void setDateHeader(@Nonnull @Nonempty String string, long l) {
        super.setDateHeader(string, l);
        this.m_aHeaderMap.setDateHeader(string, l);
    }

    public void addDateHeader(@Nonnull @Nonempty String string, long l) {
        super.addDateHeader(string, l);
        this.m_aHeaderMap.addDateHeader(string, l);
    }

    public void setHeader(@Nonnull @Nonempty String string, @Nonnull String string2) {
        super.setHeader(string, string2);
        this.m_aHeaderMap.setHeader(string, string2);
    }

    public void addHeader(@Nonnull @Nonempty String string, @Nonnull String string2) {
        super.addHeader(string, string2);
        this.m_aHeaderMap.addHeader(string, string2);
    }

    public void setIntHeader(@Nonnull @Nonempty String string, int n) {
        super.setIntHeader(string, n);
        this.m_aHeaderMap.setIntHeader(string, n);
    }

    public void addIntHeader(@Nonnull @Nonempty String string, int n) {
        super.addIntHeader(string, n);
        this.m_aHeaderMap.addIntHeader(string, n);
    }

    @Nonnull
    @ReturnsMutableObject
    public HttpHeaderMap headerMap() {
        return this.m_aHeaderMap;
    }

    @Nonnull
    public static StatusAwareHttpResponseWrapper wrap(@Nonnull HttpServletResponse httpServletResponse) {
        if (httpServletResponse instanceof StatusAwareHttpResponseWrapper) {
            return (StatusAwareHttpResponseWrapper)httpServletResponse;
        }
        return new StatusAwareHttpResponseWrapper(httpServletResponse);
    }
}

