/*
 * Decompiled with CFR 0.152.
 */
package com.helger.servlet.http;

import com.helger.servlet.http.CountingOnlyServletOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;

public class CountingOnlyHttpServletResponse
extends HttpServletResponseWrapper {
    private final CountingOnlyServletOutputStream m_aCountOnlyOS = new CountingOnlyServletOutputStream();
    private PrintWriter m_aWriter;
    private boolean m_bContentLengthSet;
    private boolean m_bUsingOutputStream;

    public CountingOnlyHttpServletResponse(HttpServletResponse httpServletResponse) {
        super(httpServletResponse);
    }

    public boolean isContentLengthSet() {
        return this.m_bContentLengthSet;
    }

    public void setContentLengthAutomatically() {
        if (!this.m_bContentLengthSet) {
            if (this.m_aWriter != null) {
                this.m_aWriter.flush();
            }
            this.setContentLengthLong(this.m_aCountOnlyOS.getContentLength());
        }
    }

    public void setContentLength(int n) {
        super.setContentLength(n);
        this.m_bContentLengthSet = true;
    }

    public void setContentLengthLong(long l) {
        super.setContentLengthLong(l);
        this.m_bContentLengthSet = true;
    }

    private void _checkHeader(String string) {
        if ("Content-Length".equalsIgnoreCase(string)) {
            this.m_bContentLengthSet = true;
        }
    }

    public void setHeader(String string, String string2) {
        super.setHeader(string, string2);
        this._checkHeader(string);
    }

    public void addHeader(String string, String string2) {
        super.addHeader(string, string2);
        this._checkHeader(string);
    }

    public void setIntHeader(String string, int n) {
        super.setIntHeader(string, n);
        this._checkHeader(string);
    }

    public void addIntHeader(String string, int n) {
        super.addIntHeader(string, n);
        this._checkHeader(string);
    }

    public ServletOutputStream getOutputStream() throws IOException {
        if (this.m_aWriter != null) {
            throw new IllegalStateException("You already called getWriter!");
        }
        this.m_bUsingOutputStream = true;
        return this.m_aCountOnlyOS;
    }

    public PrintWriter getWriter() throws UnsupportedEncodingException {
        if (this.m_bUsingOutputStream) {
            throw new IllegalStateException("You already called getOutputStream!");
        }
        if (this.m_aWriter == null) {
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)((Object)this.m_aCountOnlyOS), this.getCharacterEncoding());
            this.m_aWriter = new PrintWriter(outputStreamWriter);
        }
        return this.m_aWriter;
    }
}

