/*
 * Decompiled with CFR 0.152.
 */
package com.helger.servlet.logging;

import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.charset.CharsetHelper;
import com.helger.commons.io.stream.NonBlockingByteArrayOutputStream;
import com.helger.commons.io.stream.StreamHelper;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import javax.annotation.Nonnull;
import javax.servlet.ServletOutputStream;
import javax.servlet.WriteListener;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;

public class LoggingHttpServletResponseWrapper
extends HttpServletResponseWrapper {
    private final LoggingServletOutpuStream m_aOS = new LoggingServletOutpuStream();
    private final HttpServletResponse m_aDelegate;

    public LoggingHttpServletResponseWrapper(@Nonnull HttpServletResponse httpServletResponse) {
        super(httpServletResponse);
        this.m_aDelegate = httpServletResponse;
    }

    @Nonnull
    public ServletOutputStream getOutputStream() throws IOException {
        return this.m_aOS;
    }

    @Nonnull
    public PrintWriter getWriter() throws IOException {
        return new PrintWriter(StreamHelper.createWriter((OutputStream)this.m_aOS.m_aBAOS, (Charset)this._getCharset()));
    }

    @Nonnull
    private Charset _getCharset() {
        String string = this.m_aDelegate.getCharacterEncoding();
        return CharsetHelper.getCharsetFromNameOrDefault((String)string, (Charset)StandardCharsets.UTF_8);
    }

    @Nonnull
    public String getContentAsString() {
        return this.m_aOS.m_aBAOS.getAsString(this._getCharset());
    }

    @Nonnull
    @ReturnsMutableCopy
    public byte[] getContentAsBytes() {
        return this.m_aOS.m_aBAOS.toByteArray();
    }

    public void writeContentTo(@Nonnull OutputStream outputStream) throws IOException {
        if (!this.m_aDelegate.isCommitted() && this.m_aOS.m_aBAOS.isNotEmpty()) {
            this.m_aOS.m_aBAOS.writeTo(outputStream);
        }
    }

    private static class LoggingServletOutpuStream
    extends ServletOutputStream {
        private final NonBlockingByteArrayOutputStream m_aBAOS = new NonBlockingByteArrayOutputStream();

        private LoggingServletOutpuStream() {
        }

        public boolean isReady() {
            return true;
        }

        public void setWriteListener(WriteListener writeListener) {
        }

        public void write(int n) throws IOException {
            this.m_aBAOS.write(n);
        }

        public void write(byte[] byArray) throws IOException {
            this.m_aBAOS.write(byArray);
        }

        public void write(byte[] byArray, int n, int n2) throws IOException {
            this.m_aBAOS.write(byArray, n, n2);
        }
    }
}

