/*
 * Decompiled with CFR 0.152.
 */
package com.helger.servlet.request;

import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.collection.CollectionHelper;
import com.helger.commons.collection.impl.CommonsLinkedHashMap;
import com.helger.commons.collection.impl.ICommonsOrderedMap;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.ToStringGenerator;
import java.io.Serializable;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public final class RequestParamMapItem
implements Serializable {
    private String m_sValue;
    private final ICommonsOrderedMap<String, RequestParamMapItem> m_aChildren = new CommonsLinkedHashMap();

    public RequestParamMapItem() {
    }

    public RequestParamMapItem(@Nonnull RequestParamMapItem requestParamMapItem) {
        this.m_sValue = requestParamMapItem.m_sValue;
        this.m_aChildren.putAll(requestParamMapItem.m_aChildren);
    }

    public boolean hasValue() {
        return this.m_sValue != null;
    }

    @Nullable
    public String getValue() {
        return this.m_sValue;
    }

    @Nullable
    public String getValueTrimmed() {
        return StringHelper.trim((String)this.m_sValue);
    }

    public boolean hasChildren() {
        return this.m_aChildren.isNotEmpty();
    }

    @Nonnull
    @ReturnsMutableObject(value="design")
    public ICommonsOrderedMap<String, RequestParamMapItem> directGetChildren() {
        return this.m_aChildren;
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsOrderedMap<String, RequestParamMapItem> getAllChildren() {
        return this.m_aChildren.getClone();
    }

    public boolean containsChild(@Nullable String string) {
        return this.m_aChildren.containsKey((Object)string);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        RequestParamMapItem requestParamMapItem = (RequestParamMapItem)object;
        return EqualsHelper.equals((Object)this.m_sValue, (Object)requestParamMapItem.m_sValue) && this.m_aChildren.equals(requestParamMapItem.m_aChildren);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object)this.m_sValue).append(this.m_aChildren).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(null).appendIfNotNull("Value", (Object)this.m_sValue).appendIf("Children", this.m_aChildren, CollectionHelper::isNotEmpty).getToString();
    }

    @Nullable
    public static RequestParamMapItem create(@Nullable Object object) {
        if (object instanceof RequestParamMapItem) {
            return new RequestParamMapItem((RequestParamMapItem)object);
        }
        if (object instanceof String) {
            RequestParamMapItem requestParamMapItem = new RequestParamMapItem();
            requestParamMapItem.m_sValue = (String)object;
            return requestParamMapItem;
        }
        if (object instanceof Map) {
            RequestParamMapItem requestParamMapItem = new RequestParamMapItem();
            for (Map.Entry entry : ((Map)object).entrySet()) {
                RequestParamMapItem requestParamMapItem2 = RequestParamMapItem.create(entry.getValue());
                if (requestParamMapItem2 == null) continue;
                requestParamMapItem.m_aChildren.put((Object)((String)entry.getKey()), (Object)requestParamMapItem2);
            }
            return requestParamMapItem;
        }
        return null;
    }
}

