/*
 * Decompiled with CFR 0.152.
 */
package com.helger.servlet;

import com.helger.commons.string.StringHelper;
import com.helger.servlet.ServletContextPathHolder;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class ServletHelper {
    public static final boolean DEFAULT_LOG_EXCEPTIONS = false;
    private static final Logger LOGGER = LoggerFactory.getLogger(ServletHelper.class);
    private static final AtomicBoolean LOG_EXCEPTIONS = new AtomicBoolean(false);
    private static final ServletHelper INSTANCE = new ServletHelper();

    private ServletHelper() {
    }

    public static void setLogExceptions(boolean bl) {
        LOG_EXCEPTIONS.set(bl);
    }

    public static boolean isLogExceptions() {
        return LOG_EXCEPTIONS.get();
    }

    public static void setRequestAttribute(@Nonnull ServletRequest servletRequest, @Nonnull String string, @Nullable Object object) {
        block2: {
            try {
                servletRequest.setAttribute(string, object);
            }
            catch (Exception exception) {
                if (!ServletHelper.isLogExceptions() || !LOGGER.isWarnEnabled()) break block2;
                LOGGER.warn("[ServletHelper] Failed to set attribute '" + string + "' in HTTP request", (Throwable)exception);
            }
        }
    }

    @Nonnull
    public static String getRequestContextPath(@Nullable HttpServletRequest httpServletRequest) {
        return ServletHelper.getRequestContextPath(httpServletRequest, ServletContextPathHolder.getContextPath());
    }

    @Nonnull
    public static String getRequestContextPath(@Nullable HttpServletRequest httpServletRequest, @Nullable String string) {
        String string2;
        block4: {
            string2 = null;
            if (httpServletRequest != null) {
                try {
                    string2 = httpServletRequest.isAsyncSupported() && httpServletRequest.isAsyncStarted() ? (String)httpServletRequest.getAttribute("javax.servlet.async.context_path") : httpServletRequest.getContextPath();
                }
                catch (Exception exception) {
                    if (!ServletHelper.isLogExceptions() || !LOGGER.isWarnEnabled()) break block4;
                    LOGGER.warn("[ServletHelper] Failed to determine context path of HTTP request", (Throwable)exception);
                }
            }
        }
        if (string2 == null) {
            string2 = string;
        }
        return StringHelper.getNotNull((String)string2, (String)"");
    }

    @Nonnull
    public static String getRequestPathInfo(@Nullable HttpServletRequest httpServletRequest) {
        String string;
        block4: {
            string = null;
            if (httpServletRequest != null) {
                try {
                    string = httpServletRequest.isAsyncSupported() && httpServletRequest.isAsyncStarted() ? (String)httpServletRequest.getAttribute("javax.servlet.async.path_info") : httpServletRequest.getPathInfo();
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                }
                catch (Exception exception) {
                    if (!ServletHelper.isLogExceptions() || !LOGGER.isWarnEnabled()) break block4;
                    LOGGER.warn("[ServletHelper] Failed to determine path info of HTTP request", (Throwable)exception);
                }
            }
        }
        return string == null ? "" : string;
    }

    @Nullable
    public static String getRequestQueryString(@Nullable HttpServletRequest httpServletRequest) {
        String string;
        block3: {
            string = null;
            if (httpServletRequest != null) {
                try {
                    string = httpServletRequest.isAsyncSupported() && httpServletRequest.isAsyncStarted() ? (String)httpServletRequest.getAttribute("javax.servlet.async.query_string") : httpServletRequest.getQueryString();
                }
                catch (Exception exception) {
                    if (!ServletHelper.isLogExceptions() || !LOGGER.isWarnEnabled()) break block3;
                    LOGGER.warn("[ServletHelper] Failed to determine query string of HTTP request", (Throwable)exception);
                }
            }
        }
        return string;
    }

    @Nonnull
    public static String getRequestRequestURI(@Nullable HttpServletRequest httpServletRequest) {
        String string;
        block3: {
            string = "";
            if (httpServletRequest != null) {
                try {
                    string = httpServletRequest.isAsyncSupported() && httpServletRequest.isAsyncStarted() ? (String)httpServletRequest.getAttribute("javax.servlet.async.request_uri") : httpServletRequest.getRequestURI();
                }
                catch (Exception exception) {
                    if (!ServletHelper.isLogExceptions() || !LOGGER.isWarnEnabled()) break block3;
                    LOGGER.warn("[ServletHelper] Failed to determine request URI of HTTP request", (Throwable)exception);
                }
            }
        }
        return string;
    }

    @Nonnull
    public static StringBuffer getRequestRequestURL(@Nullable HttpServletRequest httpServletRequest) {
        StringBuffer stringBuffer;
        block3: {
            stringBuffer = null;
            if (httpServletRequest != null) {
                try {
                    stringBuffer = httpServletRequest.getRequestURL();
                }
                catch (Exception exception) {
                    if (!ServletHelper.isLogExceptions() || !LOGGER.isWarnEnabled()) break block3;
                    LOGGER.warn("[ServletHelper] Failed to determine request URL of HTTP request", (Throwable)exception);
                }
            }
        }
        return stringBuffer != null ? stringBuffer : new StringBuffer();
    }

    @Nonnull
    public static String getRequestServletPath(@Nullable HttpServletRequest httpServletRequest) {
        String string;
        block4: {
            string = "";
            if (httpServletRequest != null) {
                try {
                    string = httpServletRequest.isAsyncSupported() && httpServletRequest.isAsyncStarted() ? (String)httpServletRequest.getAttribute("javax.servlet.async.servlet_path") : httpServletRequest.getServletPath();
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                }
                catch (Exception exception) {
                    if (!ServletHelper.isLogExceptions() || !LOGGER.isWarnEnabled()) break block4;
                    LOGGER.warn("[ServletHelper] Failed to determine servlet path of HTTP request", (Throwable)exception);
                }
            }
        }
        return string;
    }

    @Nullable
    public static Cookie[] getRequestCookies(@Nullable HttpServletRequest httpServletRequest) {
        Cookie[] cookieArray;
        block3: {
            cookieArray = null;
            if (httpServletRequest != null) {
                try {
                    cookieArray = httpServletRequest.getCookies();
                }
                catch (Exception exception) {
                    if (!ServletHelper.isLogExceptions() || !LOGGER.isWarnEnabled()) break block3;
                    LOGGER.warn("[ServletHelper] Failed to determine cookies of HTTP request", (Throwable)exception);
                }
            }
        }
        return cookieArray;
    }

    public static void setRequestCharacterEncoding(@Nonnull HttpServletRequest httpServletRequest, @Nullable Charset charset) {
        ServletHelper.setRequestCharacterEncoding(httpServletRequest, charset != null ? charset.name() : null);
    }

    public static void setRequestCharacterEncoding(@Nonnull HttpServletRequest httpServletRequest, @Nullable String string) {
        block3: {
            if (StringHelper.hasText((String)string)) {
                try {
                    httpServletRequest.setCharacterEncoding(string);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    if (!LOGGER.isErrorEnabled()) break block3;
                    LOGGER.error("Failed to set request character encoding to '" + string + "'", (Throwable)unsupportedEncodingException);
                }
            }
        }
    }

    @Nonnull
    public static String getServletContextBasePath(@Nonnull ServletContext servletContext) {
        String string = servletContext.getRealPath(".");
        if (string == null) {
            string = servletContext.getRealPath("");
        }
        if (StringHelper.hasNoText((String)string)) {
            throw new IllegalStateException("Failed to determine real path of ServletContext " + servletContext);
        }
        return string;
    }
}

