/*
 * Decompiled with CFR 0.152.
 */
package com.helger.web.fileupload.parse;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.concurrent.SimpleReadWriteLock;
import com.helger.commons.io.file.FileIOError;
import com.helger.commons.io.file.FileOperations;
import com.helger.web.fileupload.IFileItemFactory;
import com.helger.web.fileupload.parse.DiskFileItem;
import java.io.File;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class DiskFileItemFactory
implements IFileItemFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(DiskFileItemFactory.class);
    protected final SimpleReadWriteLock m_aRWLock = new SimpleReadWriteLock();
    private File m_aRepository;
    private final int m_nSizeThreshold;
    private final ICommonsList<File> m_aTempFiles = new CommonsArrayList();

    public DiskFileItemFactory(@Nonnegative int n) {
        this(n, null);
    }

    public DiskFileItemFactory(@Nonnegative int n, @Nullable File file) {
        ValueEnforcer.isGT0((int)n, (String)"SizeThreshold");
        this.m_nSizeThreshold = n;
        this.setRepository(file);
    }

    @Override
    public void setRepository(@Nullable File file) {
        this.m_aRepository = file;
    }

    private void _addTempFile(@Nonnull File file) {
        this.m_aRWLock.writeLockedBoolean(() -> this.m_aTempFiles.add((Object)file));
    }

    @Override
    @Nonnull
    public DiskFileItem createItem(@Nullable String string, @Nullable String string2, boolean bl, @Nullable String string3) {
        DiskFileItem diskFileItem = new DiskFileItem(string, string2, bl, string3, this.m_nSizeThreshold, this.m_aRepository);
        this._addTempFile(diskFileItem.getTempFile());
        return diskFileItem;
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<File> getAllTemporaryFiles() {
        return (ICommonsList)this.m_aRWLock.readLockedGet(() -> this.m_aTempFiles.getClone());
    }

    public void deleteAllTemporaryFiles() {
        ICommonsList iCommonsList = (ICommonsList)this.m_aRWLock.writeLockedGet(() -> {
            ICommonsList iCommonsList = (ICommonsList)this.m_aTempFiles.getClone();
            this.m_aTempFiles.clear();
            return iCommonsList;
        });
        for (File file : iCommonsList) {
            FileIOError fileIOError = FileOperations.deleteFileIfExisting((File)file);
            if (!fileIOError.isFailure()) continue;
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error("Failed to delete temporary file " + file + " with error " + fileIOError.toString());
            }
            this._addTempFile(file);
        }
    }
}

