/*
 * Decompiled with CFR 0.152.
 */
package com.helger.web.scope.mgr;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.collection.impl.ICommonsMap;
import com.helger.commons.state.EChange;
import com.helger.scope.IScopeRenewalAware;
import com.helger.scope.ISessionScope;
import com.helger.scope.mgr.ScopeSessionManager;
import com.helger.web.scope.ISessionWebScope;
import com.helger.web.scope.mgr.WebScopeManager;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import javax.servlet.http.HttpSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
public final class WebScopeSessionHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(WebScopeSessionHelper.class);
    private static final WebScopeSessionHelper s_aInstance = new WebScopeSessionHelper();

    private WebScopeSessionHelper() {
    }

    private static void _restoreScopeAttributes(@Nonnull ISessionWebScope iSessionWebScope, @Nonnull Map<String, IScopeRenewalAware> map) {
        for (Map.Entry<String, IScopeRenewalAware> entry : map.entrySet()) {
            iSessionWebScope.attrs().putIn((Object)entry.getKey(), (Object)entry.getValue());
        }
    }

    @Nonnull
    public static EChange renewCurrentSessionScope(boolean bl) {
        ISessionWebScope iSessionWebScope = WebScopeManager.getSessionScope(false);
        if (iSessionWebScope == null) {
            return EChange.UNCHANGED;
        }
        ICommonsMap iCommonsMap = iSessionWebScope.getAllScopeRenewalAwareAttributes();
        if (bl) {
            LOGGER.info("Invalidating session " + iSessionWebScope.getID());
            iSessionWebScope.selfDestruct();
        } else {
            ScopeSessionManager.getInstance().onScopeEnd((ISessionScope)iSessionWebScope);
        }
        ISessionWebScope iSessionWebScope2 = WebScopeManager.internalGetSessionScope(true, true);
        WebScopeSessionHelper._restoreScopeAttributes(iSessionWebScope2, (Map<String, IScopeRenewalAware>)iCommonsMap);
        return EChange.CHANGED;
    }

    @Nullable
    public static ISessionWebScope renewSessionScope(@Nonnull HttpSession httpSession) {
        ValueEnforcer.notNull((Object)httpSession, (String)"HttpSession");
        ISessionWebScope iSessionWebScope = WebScopeManager.internalGetOrCreateSessionScope(httpSession, false, false);
        if (iSessionWebScope == null) {
            return null;
        }
        ICommonsMap iCommonsMap = iSessionWebScope.getAllScopeRenewalAwareAttributes();
        ScopeSessionManager.getInstance().onScopeEnd((ISessionScope)iSessionWebScope);
        ISessionWebScope iSessionWebScope2 = WebScopeManager.internalGetOrCreateSessionScope(httpSession, true, true);
        WebScopeSessionHelper._restoreScopeAttributes(iSessionWebScope2, (Map<String, IScopeRenewalAware>)iCommonsMap);
        return iSessionWebScope2;
    }
}

