/*
 * Decompiled with CFR 0.152.
 */
package com.holdenkarau.spark.testing;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.time.Duration;
import java.time.Instant;
import java.util.Arrays;
import org.apache.spark.sql.Row;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.math.BigDecimal$;
import scala.math.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

public final class DataFrameSuiteBase$
implements Serializable {
    public static DataFrameSuiteBase$ MODULE$;

    static {
        new DataFrameSuiteBase$();
    }

    public boolean approxEquals(Row r1, Row r2, double tol) {
        return this.approxEquals(r1, r2, tol, Duration.ofNanos((long)(tol * (double)1000)));
    }

    public boolean approxEquals(Row r1, Row r2, Duration tolTimestamp) {
        return this.approxEquals(r1, r2, 0.0, tolTimestamp);
    }

    public boolean approxEquals(Row r1, Row r2, double tol, Duration tolTimestamp) {
        boolean bl;
        Object object = new Object();
        try {
            if (r1.length() != r2.length()) {
                return false;
            }
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), r1.length()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & java.io.Serializable & Serializable)idx -> {
                block25: {
                    if (r1.isNullAt(idx) != r2.isNullAt(idx)) {
                        throw new NonLocalReturnControl.mcZ.sp(object, false);
                    }
                    if (r1.isNullAt(idx)) break block25;
                    Object o1 = r1.get(idx);
                    Object o2 = r2.get(idx);
                    Object object = o1;
                    if (object instanceof byte[]) {
                        byte[] byArray = (byte[])object;
                        if (!Arrays.equals(byArray, (byte[])o2)) {
                            throw new NonLocalReturnControl.mcZ.sp(object, false);
                        }
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    } else if (object instanceof Float) {
                        float f = BoxesRunTime.unboxToFloat((Object)object);
                        if (Float.isNaN(f) != Float.isNaN(BoxesRunTime.unboxToFloat((Object)o2))) {
                            throw new NonLocalReturnControl.mcZ.sp(object, false);
                        }
                        if ((double)package$.MODULE$.abs(f - BoxesRunTime.unboxToFloat((Object)o2)) > tol) {
                            throw new NonLocalReturnControl.mcZ.sp(object, false);
                        }
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    } else if (object instanceof Double) {
                        double d = BoxesRunTime.unboxToDouble((Object)object);
                        if (Double.isNaN(d) != Double.isNaN(BoxesRunTime.unboxToDouble((Object)o2))) {
                            throw new NonLocalReturnControl.mcZ.sp(object, false);
                        }
                        if (package$.MODULE$.abs(d - BoxesRunTime.unboxToDouble((Object)o2)) > tol) {
                            throw new NonLocalReturnControl.mcZ.sp(object, false);
                        }
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    } else if (object instanceof BigDecimal) {
                        BoxedUnit boxedUnit;
                        BigDecimal bigDecimal = (BigDecimal)object;
                        if (bigDecimal.compareTo((BigDecimal)o2) != 0) {
                            if (bigDecimal.subtract((BigDecimal)o2).abs().compareTo(new BigDecimal(tol)) > 0) {
                                throw new NonLocalReturnControl.mcZ.sp(object, false);
                            }
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        BoxedUnit boxedUnit2 = boxedUnit;
                    } else if (object instanceof scala.math.BigDecimal) {
                        scala.math.BigDecimal bigDecimal = (scala.math.BigDecimal)object;
                        if (bigDecimal.$minus((scala.math.BigDecimal)o2).abs().$greater((Object)BigDecimal$.MODULE$.double2bigDecimal(tol))) {
                            throw new NonLocalReturnControl.mcZ.sp(object, false);
                        }
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    } else if (object instanceof Timestamp) {
                        Instant t2Instant;
                        Timestamp timestamp = (Timestamp)object;
                        Instant t1Instant = timestamp.toInstant();
                        if (Duration.between(t1Instant, t2Instant = ((Timestamp)o2).toInstant()).abs().compareTo(tolTimestamp) > 0) {
                            throw new NonLocalReturnControl.mcZ.sp(object, false);
                        }
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    } else {
                        if (object instanceof Row) {
                            Row row = (Row)object;
                            throw new NonLocalReturnControl.mcZ.sp(object, MODULE$.approxEquals(row, (Row)o2, tol, tolTimestamp));
                        }
                        if (!BoxesRunTime.equals((Object)o1, (Object)o2)) {
                            throw new NonLocalReturnControl.mcZ.sp(object, false);
                        }
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    }
                }
            });
            bl = true;
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                bl = ex.value$mcZ$sp();
            }
            throw ex;
        }
        return bl;
    }

    private Object readResolve() {
        return MODULE$;
    }

    private DataFrameSuiteBase$() {
        MODULE$ = this;
    }
}

