/*
 * Decompiled with CFR 0.152.
 */
package com.holmos.reflect;

import com.holmos.reflect.error.HolmosReflectAssertError;
import com.holmos.reflect.reflectCheck.HolmosRefectionComparatorMode;
import com.holmos.reflect.reflectCheck.HolmosReflectionComparator;
import com.holmos.reflect.reflectCheck.comparator.HolmosComparatorFactory;
import com.holmos.reflect.reflectCheck.difference.HolmosDifference;
import com.holmos.reflect.reflectCheck.report.HolmosDefaultDifferentReport;
import com.holmos.reflect.utils.HolmosReflectionUtils;
import junit.framework.Assert;

public class HolmosReflectCheck {
    public static void assertEquals(String message, Object expected, Object actual, HolmosRefectionComparatorMode ... modes) throws HolmosReflectAssertError {
        HolmosReflectionComparator reflectionComparator = HolmosComparatorFactory.createRefectionComparator(modes);
        HolmosDifference difference = reflectionComparator.getDifference(expected, actual);
        if (difference != null) {
            throw new HolmosReflectAssertError(HolmosReflectCheck.getFailedMessage(message, difference));
        }
    }

    public static void assertLenientEquals(String message, Object expected, Object actual) throws HolmosReflectAssertError {
        HolmosReflectCheck.assertEquals(message, expected, actual, HolmosRefectionComparatorMode.DATE, HolmosRefectionComparatorMode.IGNORE_DEFAULT, HolmosRefectionComparatorMode.IGNORE_COLLECTION_ORDER);
    }

    public static void assertLenientEquals(Object expected, Object actual) {
        HolmosReflectCheck.assertLenientEquals(null, expected, actual);
    }

    public static void assertEquals(Object expected, Object actual, HolmosRefectionComparatorMode ... modes) throws HolmosReflectAssertError {
        HolmosReflectCheck.assertEquals(null, expected, actual, modes);
    }

    public static void assertFieldValueEquals(String fieldName, Object expectedFieldValue, Object actualObject) {
        HolmosReflectCheck.assertFieldValueEquals(null, fieldName, expectedFieldValue, actualObject);
    }

    public static void assertFieldValueEquals(String message, String fieldName, Object expectedFieldValue, Object actualObject) {
        Object actualFieldValue = HolmosReflectionUtils.getFieldValue(actualObject, fieldName);
        Assert.assertNotNull((String)"\u5f85\u6821\u9a8c\u7684\u5bf9\u8c61\u503c\u4e3anull.", (Object)actualObject);
        String fieldAssertMessage = String.valueOf(actualObject.getClass().getName()) + "\u7684\u5c5e\u6027" + fieldName + "\u6821\u9a8c\n" + message;
        HolmosReflectCheck.assertEquals(fieldAssertMessage, expectedFieldValue, actualFieldValue, new HolmosRefectionComparatorMode[0]);
    }

    protected static String getFailedMessage(String message, HolmosDifference difference) {
        StringBuilder result = new StringBuilder();
        result.append(message == null ? "" : String.valueOf(message) + ":\n");
        result.append(new HolmosDefaultDifferentReport().createReport(difference));
        return result.toString();
    }
}

