/*
 * Decompiled with CFR 0.152.
 */
package com.holmos.reflect.tool;

import com.holmos.reflect.tool.HolmosObjectFormatter;
import java.util.Collection;
import java.util.Map;

public class HolmosArrayAndCollectionFormatter {
    protected int maxElementCount;
    protected HolmosObjectFormatter objectFormatter;

    public HolmosArrayAndCollectionFormatter(int maxElementCount, HolmosObjectFormatter objectFormatter) {
        this.maxElementCount = maxElementCount;
        this.objectFormatter = objectFormatter;
    }

    public void formatterArrays(Object array, int currentDepth, StringBuilder result) {
        if (array instanceof byte[]) {
            this.formatByteArray((byte[])array, result);
            return;
        }
        if (array instanceof short[]) {
            this.formatShortArray((short[])array, result);
            return;
        }
        if (array instanceof int[]) {
            this.formatIntArray((int[])array, result);
            return;
        }
        if (array instanceof long[]) {
            this.formatLongArray((long[])array, result);
            return;
        }
        if (array instanceof char[]) {
            this.formatCharArray((char[])array, result);
            return;
        }
        if (array instanceof float[]) {
            this.formatFloatArray((float[])array, result);
            return;
        }
        if (array instanceof double[]) {
            this.formatDoubleArray((double[])array, result);
            return;
        }
        if (array instanceof boolean[]) {
            this.formatBooleanArray((boolean[])array, result);
            return;
        }
        this.formatObjectArray((Object[])array, currentDepth, result);
    }

    private void formatObjectArray(Object[] array, int currentDepth, StringBuilder result) {
        result.append("[");
        int i = 0;
        while (i < array.length && i < this.maxElementCount) {
            if (i > 0) {
                result.append(',');
            }
            this.formatObjectArray(array, currentDepth + 1, result);
            ++i;
        }
        if (i < array.length) {
            result.append("...");
        }
        result.append("]");
    }

    private void formatBooleanArray(boolean[] array, StringBuilder result) {
        result.append("[");
        int i = 0;
        while (i < array.length && i < this.maxElementCount) {
            if (i > 0) {
                result.append(',');
            }
            result.append(array[i]);
            ++i;
        }
        if (i < array.length) {
            result.append("...");
        }
        result.append("]");
    }

    private void formatDoubleArray(double[] array, StringBuilder result) {
        result.append("[");
        int i = 0;
        while (i < array.length && i < this.maxElementCount) {
            if (i > 0) {
                result.append(',');
            }
            result.append(array[i]);
            ++i;
        }
        if (i < array.length) {
            result.append("...");
        }
        result.append("]");
    }

    private void formatFloatArray(float[] array, StringBuilder result) {
        result.append("[");
        int i = 0;
        while (i < array.length && i < this.maxElementCount) {
            if (i > 0) {
                result.append(',');
            }
            result.append(array[i]);
            ++i;
        }
        if (i < array.length) {
            result.append("...");
        }
        result.append("]");
    }

    private void formatCharArray(char[] array, StringBuilder result) {
        result.append("[");
        int i = 0;
        while (i < array.length && i < this.maxElementCount) {
            if (i > 0) {
                result.append(',');
            }
            result.append(array[i]);
            ++i;
        }
        if (i < array.length) {
            result.append("...");
        }
        result.append("]");
    }

    private void formatLongArray(long[] array, StringBuilder result) {
        result.append("[");
        int i = 0;
        while (i < array.length && i < this.maxElementCount) {
            if (i > 0) {
                result.append(',');
            }
            result.append(array[i]);
            ++i;
        }
        if (i < array.length) {
            result.append("...");
        }
        result.append("]");
    }

    private void formatIntArray(int[] array, StringBuilder result) {
        result.append("[");
        int i = 0;
        while (i < array.length && i < this.maxElementCount) {
            if (i > 0) {
                result.append(',');
            }
            result.append(array[i]);
            ++i;
        }
        if (i < array.length) {
            result.append("...");
        }
        result.append("]");
    }

    private void formatShortArray(short[] array, StringBuilder result) {
        result.append("[");
        int i = 0;
        while (i < array.length && i < this.maxElementCount) {
            if (i > 0) {
                result.append(',');
            }
            result.append(array[i]);
            ++i;
        }
        if (i < array.length) {
            result.append("...");
        }
        result.append("]");
    }

    private void formatByteArray(byte[] array, StringBuilder result) {
        result.append("[");
        int i = 0;
        while (i < array.length && i < this.maxElementCount) {
            if (i > 0) {
                result.append(',');
            }
            result.append(array[i]);
            ++i;
        }
        if (i < array.length) {
            result.append("...");
        }
        result.append("]");
    }

    public void formatCollection(Collection<?> collection, int currentDepth, StringBuilder result) {
        result.append("[");
        int i = 0;
        for (Object element : collection) {
            if (i > 0) {
                result.append(",");
            }
            this.objectFormatter.formatImpl(element, currentDepth + 1, result);
            if (i >= this.maxElementCount && i < collection.size()) {
                result.append("...");
                break;
            }
            ++i;
        }
        result.append("]");
    }

    public void formatMap(Map<?, ?> map, int currentDepth, StringBuilder result) {
        result.append("[");
        int i = 0;
        for (Map.Entry<?, ?> element : map.entrySet()) {
            if (i > 0) {
                result.append(",");
            }
            this.objectFormatter.formatImpl(element.getKey(), currentDepth, result);
            result.append("=");
            this.objectFormatter.formatImpl(element.getValue(), currentDepth + 1, result);
            if (i >= this.maxElementCount && i < map.size()) {
                result.append("...");
                break;
            }
            ++i;
        }
        result.append("]");
    }
}

