/*
 * Decompiled with CFR 0.152.
 */
package com.holmos.reflect.tool;

import com.holmos.reflect.tool.HolmosArrayAndCollectionFormatter;
import java.io.File;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import org.apache.commons.lang.ClassUtils;

public class HolmosObjectFormatter {
    private int maxDepth;
    private int maxCollectionArrayElementCount;
    private HolmosArrayAndCollectionFormatter holmosArrayAndCollectionFormatter;

    public HolmosObjectFormatter(int maxDepth, int maxCollectionArrayElementCount) {
        this.maxDepth = maxDepth;
        this.maxCollectionArrayElementCount = maxCollectionArrayElementCount;
        this.holmosArrayAndCollectionFormatter = new HolmosArrayAndCollectionFormatter(maxCollectionArrayElementCount, this);
    }

    public HolmosObjectFormatter() {
        this(5, 20);
    }

    public String format(Object object) {
        StringBuilder result = new StringBuilder();
        this.formatImpl(object, 0, result);
        return result.toString();
    }

    public void formatImpl(Object object, int currentDepth, StringBuilder result) {
        if (object == null) {
            result.append(String.valueOf(object));
            return;
        }
        if (this.formatString(object, result)) {
            return;
        }
        if (this.formatNumberOrDate(object, result)) {
            return;
        }
        Class<?> type = object.getClass();
        if (this.formatCharacter(object, type, result)) {
            return;
        }
        if (this.formatPrimitiveOrEnum(object, type, result)) {
            return;
        }
        if (this.formatMock(object, result)) {
            return;
        }
        if (this.formatProxy(object, type, result)) {
            return;
        }
        if (this.formatJavaLang(object, result, type)) {
            return;
        }
        if (type.isArray()) {
            this.holmosArrayAndCollectionFormatter.formatterArrays(object, currentDepth, result);
            return;
        }
        if (object instanceof Collection) {
            this.holmosArrayAndCollectionFormatter.formatCollection((Collection)object, currentDepth, result);
            return;
        }
        if (object instanceof Map) {
            this.holmosArrayAndCollectionFormatter.formatMap((Map)object, currentDepth, result);
            return;
        }
        if (currentDepth >= this.maxDepth) {
            result.append(ClassUtils.getShortClassName(type));
            result.append("<...>");
            return;
        }
        if (this.formatFile(object, result)) {
            return;
        }
        this.formatObject(object, currentDepth, result);
    }

    private void formatObject(Object object, int currentDepth, StringBuilder result) {
        Class<?> type = object.getClass();
        result.append(ClassUtils.getShortClassName(type));
        result.append("<");
        this.formatFields(object, type, currentDepth, result);
        result.append(">");
    }

    private void formatFields(Object object, Class<?> clazz, int currentDepth, StringBuilder result) {
        AccessibleObject[] fields = clazz.getDeclaredFields();
        AccessibleObject.setAccessible(fields, true);
        int i = 0;
        while (i < fields.length) {
            AccessibleObject field = fields[i];
            if (!(Modifier.isTransient(((Field)field).getModifiers()) || Modifier.isStatic(((Field)field).getModifiers()) || ((Field)field).isSynthetic())) {
                try {
                    if (i > 0) {
                        result.append(", ");
                    }
                    result.append(((Field)field).getName());
                    result.append("=");
                    this.formatImpl(((Field)field).get(object), currentDepth + 1, result);
                }
                catch (IllegalAccessException e) {
                    throw new InternalError("Unexpected IllegalAccessException");
                }
            }
            ++i;
        }
        Class<?> superclazz = clazz.getSuperclass();
        while (superclazz != null && !superclazz.getName().startsWith("java.lang")) {
            this.formatFields(object, superclazz, currentDepth, result);
            superclazz = superclazz.getSuperclass();
        }
    }

    private boolean formatFile(Object object, StringBuilder result) {
        if (object instanceof File) {
            result.append("File<");
            result.append(((File)object).getPath());
            result.append(">");
            return true;
        }
        return false;
    }

    private boolean formatJavaLang(Object object, StringBuilder result, Class<?> type) {
        if (type.getName().startsWith("java.lang")) {
            result.append(String.valueOf(object));
            return true;
        }
        return false;
    }

    private boolean formatProxy(Object object, Class<?> type, StringBuilder result) {
        return false;
    }

    private boolean formatMock(Object object, StringBuilder result) {
        return false;
    }

    private boolean formatPrimitiveOrEnum(Object object, Class<?> type, StringBuilder result) {
        if (type.isPrimitive() || type.isEnum()) {
            result.append(String.valueOf(object));
            return true;
        }
        return false;
    }

    private boolean formatCharacter(Object object, Class<?> type, StringBuilder result) {
        if (object instanceof Character) {
            result.append("'" + String.valueOf(object) + "'");
            return true;
        }
        return false;
    }

    private boolean formatNumberOrDate(Object object, StringBuilder result) {
        if (object instanceof Number || object instanceof Date) {
            result.append(String.valueOf(object));
            return true;
        }
        return false;
    }

    private boolean formatString(Object object, StringBuilder result) {
        if (object instanceof String) {
            result.append("\"");
            result.append(object);
            result.append("\"");
            return true;
        }
        return false;
    }
}

