/*
 * Decompiled with CFR 0.152.
 */
package com.holmos.webtest.customunitls;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class DateUnitls {
    public static String dateToStr(Date date, String pattern) {
        if (pattern == null) {
            pattern = "yyyy-MM-dd HH:mm:ss.SSS";
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat(pattern);
        return dateFormat.format(date);
    }

    public static Date strToDate(String strDate, String pattern) throws ParseException {
        if (pattern == null) {
            pattern = "yyyy-MM-dd HH:mm:ss.SSS";
        }
        SimpleDateFormat dataFormat = new SimpleDateFormat(pattern);
        return dataFormat.parse(strDate);
    }

    public static Date getToday() {
        Calendar calendar = Calendar.getInstance();
        return calendar.getTime();
    }

    public static Date makeDate(int year, int month, int date) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(year, month - 1, date);
        SimpleDateFormat dataFormat = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
        dataFormat.format(calendar.getTime());
        return calendar.getTime();
    }

    public static boolean compareDate(Date date1, Date date2) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd HH:mm");
        return dateFormat.format(date1).equals(dateFormat.format(date2));
    }

    public static int getWeekOrder(int year, int month, int day) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(1, year);
        calendar.set(2, month);
        calendar.set(5, day);
        return calendar.get(3);
    }

    public int getDaysBetween(Calendar startCalendar, Calendar endCalendar) {
        if (startCalendar.after(endCalendar)) {
            Calendar swap = startCalendar;
            startCalendar = endCalendar;
            endCalendar = swap;
        }
        int days = endCalendar.get(6) - startCalendar.get(6);
        int year = endCalendar.get(1);
        if (startCalendar.get(1) != year) {
            startCalendar = (Calendar)startCalendar.clone();
            do {
                days += startCalendar.getActualMaximum(6);
                startCalendar.add(1, 1);
            } while (startCalendar.get(1) != year);
        }
        return days;
    }
}

