/*
 * Decompiled with CFR 0.152.
 */
package com.holmos.webtest.element;

import com.holmos.webtest.Allocator;
import com.holmos.webtest.BrowserWindow;
import com.holmos.webtest.SeleniumBrowserWindow;
import com.holmos.webtest.WebDriverBrowserWindow;
import com.holmos.webtest.element.Element;
import com.thoughtworks.selenium.Selenium;
import java.util.List;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.ui.Select;

public class Comobobox
extends Element {
    private Select select;

    public Comobobox(String comment) {
        super(comment);
    }

    @Override
    public boolean isExist() {
        if (super.isExist()) {
            this.select = new Select(this.element);
            return true;
        }
        return false;
    }

    public void selectByIndex(int index) {
        StringBuilder message = new StringBuilder();
        BrowserWindow currentWindow = Allocator.getInstance().currentWindow;
        if (this.isExist()) {
            message.append(String.valueOf(this.wholeComment) + ":");
            if (currentWindow instanceof SeleniumBrowserWindow) {
                ((Selenium)currentWindow.getDriver().getEngine()).select(this.locator.getSeleniumCurrentLocator(), "index=" + index);
            } else if (currentWindow instanceof WebDriverBrowserWindow) {
                this.select.selectByIndex(index);
            }
            message.append("\u9009\u62e9\u7b2c" + index + "\u4e2a\u9009\u9879\u6210\u529f\uff01");
            this.logger.info(message);
        } else {
            message.append(String.valueOf(this.wholeComment) + ":");
            message.append("\u6839\u636e\u7d22\u5f15\u9009\u62e9\u5931\u8d25!\u627e\u4e0d\u5230\u5143\u7d20");
            this.logger.error(message);
        }
    }

    public void selectByValue(String value) {
        StringBuilder message = new StringBuilder();
        BrowserWindow currentWindow = Allocator.getInstance().currentWindow;
        if (this.isExist()) {
            message.append(String.valueOf(this.wholeComment) + ":");
            if (currentWindow instanceof SeleniumBrowserWindow) {
                ((Selenium)currentWindow.getDriver().getEngine()).select(this.locator.getSeleniumCurrentLocator(), "value=" + value);
            } else if (currentWindow instanceof WebDriverBrowserWindow) {
                this.select.selectByValue(value);
            }
            message.append("\u9009\u62e9" + value + "\u6240\u5728\u9009\u9879\u6210\u529f\uff01");
            this.logger.info(message);
        } else {
            message.append(String.valueOf(this.wholeComment) + ":");
            message.append("\u6839\u636e\u5185\u5bb9\u9009\u62e9\u5931\u8d25!\u627e\u4e0d\u5230\u5143\u7d20");
            this.logger.error(message);
        }
    }

    public void selectByVisiableValue(String value) {
        StringBuilder message = new StringBuilder();
        BrowserWindow currentWindow = Allocator.getInstance().currentWindow;
        if (this.isExist()) {
            message.append(String.valueOf(this.wholeComment) + ":");
            if (currentWindow instanceof SeleniumBrowserWindow) {
                ((Selenium)currentWindow.getDriver().getEngine()).select(this.locator.getSeleniumCurrentLocator(), "label=" + value);
            } else if (currentWindow instanceof WebDriverBrowserWindow) {
                this.select.selectByVisibleText(value);
            }
            message.append("\u9009\u62e9" + value + "\u6240\u5728\u9009\u9879\u6210\u529f\uff01");
            this.logger.info(message);
        } else {
            message.append(String.valueOf(this.wholeComment) + ":");
            message.append("\u6839\u636e\u53ef\u89c1\u5185\u5bb9\u9009\u62e9\u5931\u8d25!\u627e\u4e0d\u5230\u5143\u7d20");
            this.logger.error(message);
        }
    }

    public int getSelectedIndex() {
        StringBuilder message = new StringBuilder();
        BrowserWindow currentWindow = Allocator.getInstance().currentWindow;
        int selectedIndex = -1;
        if (this.isExist()) {
            message.append(String.valueOf(this.wholeComment) + ":");
            if (currentWindow instanceof SeleniumBrowserWindow) {
                selectedIndex = Integer.parseInt(((Selenium)currentWindow.getDriver().getEngine()).getSelectedIndex(this.locator.getSeleniumCurrentLocator()));
            } else if (currentWindow instanceof WebDriverBrowserWindow) {
                List allItems = this.select.getOptions();
                WebElement selectedItem = this.select.getFirstSelectedOption();
                int i = 0;
                while (i < allItems.size()) {
                    if (((WebElement)allItems.get(i)).equals(selectedItem)) {
                        selectedIndex = i;
                        break;
                    }
                    ++i;
                }
            }
            message.append("\u83b7\u5f97\u9009\u4e2d\u9879\u7684\u7d22\u5f15\u6210\u529f\uff01");
            this.logger.info(message);
        } else {
            message.append(String.valueOf(this.wholeComment) + ":");
            message.append("\u83b7\u5f97\u9009\u4e2d\u9879\u7684\u7d22\u5f15\u5931\u8d25!\u627e\u4e0d\u5230\u5143\u7d20");
            this.logger.error(message);
        }
        return selectedIndex;
    }

    public String getSelectedValue() {
        StringBuilder message = new StringBuilder();
        BrowserWindow currentWindow = Allocator.getInstance().currentWindow;
        String selectedValue = null;
        if (this.isExist()) {
            message.append(String.valueOf(this.wholeComment) + ":");
            if (currentWindow instanceof SeleniumBrowserWindow) {
                selectedValue = ((Selenium)currentWindow.getDriver().getEngine()).getSelectedValue(this.locator.getSeleniumCurrentLocator());
            } else if (currentWindow instanceof WebDriverBrowserWindow) {
                selectedValue = this.select.getFirstSelectedOption().getText();
            }
        } else {
            message.append(String.valueOf(this.wholeComment) + ":");
            message.append("\u83b7\u5f97\u9009\u4e2d\u9879\u7684\u5185\u5bb9\u5931\u8d25!\u627e\u4e0d\u5230\u5143\u7d20");
            this.logger.error(message);
        }
        return selectedValue;
    }

    public String[] getSelectedValues() {
        StringBuilder message = new StringBuilder();
        BrowserWindow currentWindow = Allocator.getInstance().currentWindow;
        String[] selectedValue = null;
        if (this.isExist()) {
            message.append(String.valueOf(this.wholeComment) + ":");
            if (currentWindow instanceof SeleniumBrowserWindow) {
                selectedValue = ((Selenium)currentWindow.getDriver().getEngine()).getSelectedValues(this.locator.getSeleniumCurrentLocator());
            } else if (currentWindow instanceof WebDriverBrowserWindow) {
                List selectedItems = this.select.getAllSelectedOptions();
                selectedValue = new String[selectedItems.size()];
                int i = 0;
                while (i < selectedItems.size()) {
                    selectedValue[i] = ((WebElement)selectedItems.get(i)).getText();
                    ++i;
                }
            }
            message.append("\u83b7\u5f97\u9009\u4e2d\u9879\u7684\u5185\u5bb9\u6210\u529f!");
            this.logger.error(message);
        } else {
            message.append(String.valueOf(this.wholeComment) + ":");
            message.append("\u83b7\u5f97\u9009\u4e2d\u9879\u7684\u5185\u5bb9\u5931\u8d25!\u627e\u4e0d\u5230\u5143\u7d20");
            this.logger.error(message);
        }
        return selectedValue;
    }

    public int[] getSelectedIndexes() {
        StringBuilder message = new StringBuilder();
        BrowserWindow currentWindow = Allocator.getInstance().currentWindow;
        int[] selectedIndexes = null;
        if (this.isExist()) {
            message.append(String.valueOf(this.wholeComment) + ":");
            if (currentWindow instanceof SeleniumBrowserWindow) {
                String[] selectedIndexesTemp = ((Selenium)currentWindow.getDriver().getEngine()).getSelectedIndexes(this.locator.getSeleniumCurrentLocator());
                int i = 0;
                while (i < selectedIndexesTemp.length) {
                    selectedIndexes[i] = Integer.parseInt(selectedIndexesTemp[i]);
                    ++i;
                }
            } else if (currentWindow instanceof WebDriverBrowserWindow) {
                List selectedItems = this.select.getAllSelectedOptions();
                List allItems = this.select.getOptions();
                selectedIndexes = new int[selectedItems.size()];
                int i = 0;
                while (i < selectedItems.size()) {
                    int j = 0;
                    while (j < selectedItems.size()) {
                        if (((WebElement)selectedItems.get(i)).equals(allItems.get(j))) {
                            selectedIndexes[i] = j;
                            break;
                        }
                        ++j;
                    }
                    ++i;
                }
            }
            message.append("\u83b7\u5f97\u9009\u4e2d\u9879\u7684\u5185\u5bb9\u6210\u529f!");
            this.logger.error(message);
        } else {
            message.append(String.valueOf(this.wholeComment) + ":");
            message.append("\u83b7\u5f97\u9009\u4e2d\u9879\u7684\u5185\u5bb9\u5931\u8d25!\u627e\u4e0d\u5230\u5143\u7d20");
            this.logger.error(message);
        }
        return selectedIndexes;
    }

    public String[] getItems() {
        StringBuilder message = new StringBuilder();
        BrowserWindow currentWindow = Allocator.getInstance().currentWindow;
        String[] allItems = null;
        if (this.isExist()) {
            message.append(String.valueOf(this.wholeComment) + ":");
            if (currentWindow instanceof SeleniumBrowserWindow) {
                allItems = ((Selenium)currentWindow.getDriver().getEngine()).getSelectOptions(this.locator.getSeleniumCurrentLocator());
            } else if (currentWindow instanceof WebDriverBrowserWindow) {
                List allItemsTemp = this.select.getOptions();
                allItems = new String[allItemsTemp.size()];
                int i = 0;
                while (i < allItems.length) {
                    allItems[i] = ((WebElement)allItemsTemp.get(i)).getText();
                    ++i;
                }
            }
            message.append("\u83b7\u53d6\u6240\u6709\u9009\u9879\u503c\u6210\u529f\uff01");
            this.logger.info(message);
        } else {
            message.append(String.valueOf(this.wholeComment) + ":");
            message.append("\u83b7\u53d6\u6240\u6709\u9009\u9879\u503c\u5931\u8d25\uff0c\u627e\u4e0d\u5230\u5143\u7d20\uff01");
            this.logger.error(message);
        }
        return allItems;
    }

    public int getComboboxSize() {
        StringBuilder message = new StringBuilder();
        BrowserWindow currentWindow = Allocator.getInstance().currentWindow;
        int size = -1;
        if (this.isExist()) {
            message.append(String.valueOf(this.wholeComment) + ":");
            if (currentWindow instanceof SeleniumBrowserWindow) {
                size = ((Selenium)currentWindow.getDriver().getEngine()).getSelectOptions(this.locator.getSeleniumCurrentLocator()).length;
            } else if (currentWindow instanceof WebDriverBrowserWindow) {
                size = this.select.getOptions().size();
            }
            message.append("\u83b7\u53d6combobox\u7684\u5927\u5c0f\u6210\u529f\uff01");
            this.logger.info(message);
        } else {
            message.append(String.valueOf(this.wholeComment) + ":");
            message.append("\u83b7\u53d6combobox\u7684\u5927\u5c0f\u5931\u8d25\uff0c\u627e\u4e0d\u5230\u5143\u7d20\uff01");
            this.logger.error(message);
        }
        return size;
    }
}

