/*
 * Decompiled with CFR 0.152.
 */
package com.holmos.webtest.element.custom;

import com.holmos.webtest.Allocator;
import com.holmos.webtest.BrowserWindow;
import com.holmos.webtest.SeleniumBrowserWindow;
import com.holmos.webtest.WebDriverBrowserWindow;
import com.holmos.webtest.element.TextField;
import com.holmos.webtest.utils.HolmosWindow;
import com.thoughtworks.selenium.Selenium;
import java.awt.AWTException;
import java.awt.Robot;

public class AlipayElement
extends TextField {
    public AlipayElement(String comment) {
        super(comment);
    }

    @Override
    public void setText(String value) {
        StringBuilder message = new StringBuilder();
        BrowserWindow currentWindow = Allocator.getInstance().currentWindow;
        if (this.isExist()) {
            message.append(String.valueOf(this.comment) + ":");
            if (currentWindow instanceof SeleniumBrowserWindow) {
                ((Selenium)currentWindow.getDriver().getEngine()).type(this.locator.getSeleniumCurrentLocator(), value);
            } else if (currentWindow instanceof WebDriverBrowserWindow) {
                HolmosWindow.runJavaScript("return arguments[0].focus();", this.element);
                this.setValueByRobot(value);
            }
            message.append("\u8bbe\u7f6e\u503c\u6210\u529f!");
            this.logger.info(message);
        } else {
            message.append(String.valueOf(this.comment) + ":");
            message.append("\u8bbe\u7f6e\u503c\u5931\u8d25!\u627e\u4e0d\u5230\u5143\u7d20!");
            this.logger.error(message);
        }
    }

    private void setValueByRobot(String value) {
        try {
            Robot robot = new Robot();
            String text = value.toUpperCase();
            int i = 0;
            while (i < text.length()) {
                robot.keyPress(text.charAt(i));
                ++i;
            }
        }
        catch (AWTException ex) {
            this.logger.error("\u963f\u91cc\u5df4\u5df4\u5b89\u5168\u63a7\u4ef6\u8bbe\u7f6e\u503c\u5931\u8d25!");
        }
    }
}

