/*
 * Decompiled with CFR 0.152.
 */
package com.holmos.webtest.junitextentions;

import com.holmos.webtest.exceptions.HolmosFailedError;
import com.holmos.webtest.junitextentions.annotations.DataBase;
import com.holmos.webtest.junitextentions.annotations.Parameter;
import com.holmos.webtest.junitextentions.annotations.RunAfter;
import com.holmos.webtest.junitextentions.annotations.Source;
import com.holmos.webtest.junitextentions.annotations.Timesout;
import com.holmos.webtest.junitextentions.parameters.HolmosFrameWorkMethod;
import com.holmos.webtest.junitextentions.parameters.ParameterDataInfo;
import com.holmos.webtest.junitextentions.parameters.ParameterFrameWorkMethod;
import com.holmos.webtest.junitextentions.parameters.database.ConnectionInfo;
import com.holmos.webtest.junitextentions.parameters.getter.DataGetter;
import com.holmos.webtest.junitextentions.parameters.getter.DataGetterFactory;
import com.holmos.webtest.junitextentions.parameters.getter.DatabaseDataGetter;
import com.holmos.webtest.utils.HolmosAnnotationUtils;
import com.holmos.webtest.utils.HolmosBaseUtils;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.junit.Test;
import org.junit.runner.Description;
import org.junit.runner.manipulation.Filter;
import org.junit.runner.manipulation.NoTestsRemainException;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.ParentRunner;
import org.junit.runners.model.FrameworkField;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.RunnerScheduler;
import org.junit.runners.model.Statement;

public class HolmosRunner
extends ParentRunner<ParameterFrameWorkMethod> {
    private ArrayList<String> runMethod = new ArrayList();
    private List<ParameterFrameWorkMethod> children;
    private ArrayList<HolmosFrameWorkMethod> holmosMethods;
    private HashMap<String, ConnectionInfo> connections = new HashMap();
    private ArrayList<ParameterDataInfo> parameterDataGetters;
    private int testClassTimesout;
    private Object testTarget;
    private HashMap<String, ParameterDataInfo> sourceInfo = new HashMap();
    public static HashMap<Integer, ParameterDataInfo> sources = new HashMap();
    private static Class<?> testClassforGetter;
    private List<ParameterFrameWorkMethod> fFilteredChildren = null;
    private RunnerScheduler fScheduler = new RunnerScheduler(){

        public void schedule(Runnable childStatement) {
            childStatement.run();
        }

        public void finished() {
            if (HolmosRunner.this.testClassTimesout == -1) {
                while (true) {
                    if (this.isAllexecuted()) {
                        return;
                    }
                    HolmosBaseUtils.sleep(30);
                }
            }
            int i = 0;
            int milliseconds = 1000 * HolmosRunner.this.testClassTimesout;
            do {
                if (i < milliseconds) continue;
                throw new HolmosFailedError(String.valueOf(HolmosRunner.this.getTestClass().getName()) + "\u6267\u884c\u8d85\u65f6\uff0c\u8bbe\u7f6e\u7684\u8d85\u65f6\u65f6\u95f4\u4e3a" + HolmosRunner.this.testClassTimesout + "\u79d2!");
            } while (!this.isAllexecuted());
        }

        private boolean isAllexecuted() {
            for (ParameterFrameWorkMethod method : HolmosRunner.this.getFilteredChildren()) {
                if (HolmosRunner.this.getMethodByName(method.getName()).isExecuted()) continue;
                return false;
            }
            return true;
        }
    };

    public static Class<?> getTestClassForGetter() {
        return testClassforGetter;
    }

    public HolmosRunner(Class<?> klass) throws InitializationError {
        super(klass);
        try {
            this.getTestTarget();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.validatePublicModiferWithAnnotation(Source.class);
        this.validatePublicModiferWithAnnotation(Parameter.class);
        this.volidateDeadLockExcuteOrder();
        this.initDataGetters();
        this.initExecuteOrderInfo();
        this.initTestClassTimesout();
    }

    private void initTestClassTimesout() {
        Timesout timesout = HolmosAnnotationUtils.getClassLevelAnnotation(this.getTestClass().getClass(), Timesout.class);
        if (timesout != null) {
            this.testClassTimesout = timesout.value();
            if (this.testClassTimesout <= 0) {
                this.testClassTimesout = 1;
            }
        } else {
            this.testClassTimesout = -1;
        }
    }

    protected List<ParameterFrameWorkMethod> getChildren() {
        return this.computeTestMethods();
    }

    protected Description describeChild(ParameterFrameWorkMethod method) {
        Description description = Description.createTestDescription((Class)this.getTestClass().getJavaClass(), (String)this.testName(method), (Annotation[])method.getAnnotations());
        return description;
    }

    protected void runChild(ParameterFrameWorkMethod child, RunNotifier notifier) {
        try {
            HolmosFrameWorkMethod holmosFrameWorkMethod = this.getMethodByName(child.getName());
            if (this.runMethod.contains(holmosFrameWorkMethod.getMethod().getName())) {
                return;
            }
            this.runMethod.add(holmosFrameWorkMethod.getMethod().getName());
            holmosFrameWorkMethod.setTarget(this.getTestTarget());
            holmosFrameWorkMethod.setNotifier(notifier);
            if (!holmosFrameWorkMethod.hasPrecursorMethod()) {
                holmosFrameWorkMethod.invokeExplosively(this.getTestTarget(), notifier);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    protected Statement childrenInvoker(final RunNotifier notifier) {
        return new Statement(){

            public void evaluate() {
                HolmosRunner.this.runChildren(notifier);
            }
        };
    }

    private boolean shouldRun(Filter filter, ParameterFrameWorkMethod each) {
        return filter.shouldRun(this.describeChild(each));
    }

    public void filter(Filter filter) throws NoTestsRemainException {
        Iterator<ParameterFrameWorkMethod> iter = this.getFilteredChildren().iterator();
        while (iter.hasNext()) {
            ParameterFrameWorkMethod each = iter.next();
            if (this.shouldRun(filter, each)) {
                try {
                    filter.apply((Object)each);
                }
                catch (NoTestsRemainException e) {
                    iter.remove();
                }
                continue;
            }
            iter.remove();
        }
        if (this.getFilteredChildren().isEmpty()) {
            throw new NoTestsRemainException();
        }
    }

    private void runChildren(final RunNotifier notifier) {
        for (final ParameterFrameWorkMethod each : this.getFilteredChildren()) {
            this.fScheduler.schedule(new Runnable(){

                @Override
                public void run() {
                    HolmosRunner.this.runChild(each, notifier);
                }
            });
        }
        this.fScheduler.finished();
    }

    private List<ParameterFrameWorkMethod> getFilteredChildren() {
        if (this.fFilteredChildren == null) {
            this.fFilteredChildren = new ArrayList<ParameterFrameWorkMethod>(this.getChildren());
        }
        return this.fFilteredChildren;
    }

    protected String testName(FrameworkMethod method) {
        if (method instanceof ParameterFrameWorkMethod) {
            String name = method.toString();
            ((ParameterFrameWorkMethod)method).setMethodName(null);
            return name;
        }
        return method.getName();
    }

    protected Object getTestTarget() throws Exception {
        if (this.testTarget == null) {
            this.testTarget = this.getTestClass().getOnlyConstructor().newInstance(new Object[0]);
        }
        testClassforGetter = this.testTarget.getClass();
        return this.testTarget;
    }

    private void initExecuteOrderInfo() {
        if (this.holmosMethods == null) {
            this.computeTestMethods();
        }
        for (HolmosFrameWorkMethod method : this.holmosMethods) {
            RunAfter runAfter = (RunAfter)method.getMethod().getAnnotation(RunAfter.class);
            if (runAfter == null) continue;
            HolmosFrameWorkMethod precursorMethod = this.getMethodByName(runAfter.methodName());
            if (precursorMethod != null) {
                precursorMethod.addSuccessorMethods(method);
                continue;
            }
            throw new HolmosFailedError("\u65b9\u6cd5" + method.getMethod().getName() + "\u7684@RunAfter\u6ce8\u89e3\u91cc\u9762\u7684\u65b9\u6cd5\u540d\u5b57\u5728\u6b64\u6d4b\u8bd5\u7c7b\u91cc\u9762\u4e0d\u5b58\u5728\uff0c\u8bf7\u60a8\u68c0\u67e5!");
        }
    }

    private HolmosFrameWorkMethod getMethodByName(String methodName) {
        for (HolmosFrameWorkMethod method : this.getHolmosMethods()) {
            if (!method.getMethod().getName().equalsIgnoreCase(methodName)) continue;
            return method;
        }
        return null;
    }

    protected List<ParameterFrameWorkMethod> computeTestMethods() {
        if (this.children == null) {
            this.children = new ArrayList<ParameterFrameWorkMethod>();
            this.holmosMethods = new ArrayList();
            for (FrameworkMethod method : this.getTestClass().getAnnotatedMethods(Test.class)) {
                this.wrapperMethod(method);
            }
        }
        return this.children;
    }

    private ArrayList<HolmosFrameWorkMethod> getHolmosMethods() {
        if (this.holmosMethods == null) {
            this.computeTestMethods();
        }
        return this.holmosMethods;
    }

    private void wrapperMethod(FrameworkMethod method) {
        HolmosFrameWorkMethod holmosMethod = new HolmosFrameWorkMethod(method);
        if (holmosMethod.isMultiThread()) {
            this.holmosMethods.add(0, holmosMethod);
            this.children.addAll(0, holmosMethod.getExcuteFrameWorkMethods());
        } else {
            this.holmosMethods.add(holmosMethod);
            this.children.addAll(holmosMethod.getExcuteFrameWorkMethods());
        }
        this.wrapperDataGetter(holmosMethod);
    }

    private void wrapperDataGetter(HolmosFrameWorkMethod method) {
        Source source = (Source)method.getMethod().getAnnotation(Source.class);
        if (source != null) {
            method.setGetter(sources.get(source.sourceID()));
        }
    }

    private void initDataGetters() {
        this.parameterDataGetters = new ArrayList();
        this.initDataBaseConnections();
        for (Source source : this.getSourceAnnotations()) {
            this.volidateValueOfSourceAnnotation(source);
            String mark = this.getValueOfSourceAnnotation(source);
            if (this.sourceInfo.get(mark) != null) {
                throw new HolmosFailedError("\u914d\u7f6e\u4e86\u76f8\u540c\u7684\u6570\u636e\u6e90\u4fe1\u606f:" + mark);
            }
            DataGetter getter = DataGetterFactory.getDataGetter(source);
            if (!source.selector().equalsIgnoreCase("") && source.selector() != null) {
                if (this.connections.get(source.connectionName()) == null) {
                    throw new HolmosFailedError(String.valueOf(source.connectionName()) + "\u6ca1\u6709\u4e3a\u6570\u636e\u6e90\u914d\u7f6e\u6570\u636e\u5e93\u8fde\u63a5!");
                }
                ((DatabaseDataGetter)getter).setConnection(this.connections.get(source.connectionName()));
            }
            ParameterDataInfo parameterDataInfo = new ParameterDataInfo(getter);
            this.parameterDataGetters.add(parameterDataInfo);
            this.sourceInfo.put(mark, parameterDataInfo);
            if (sources.get(source.sourceID()) != null) {
                throw new HolmosFailedError("\u4e0d\u540c\u7684\u53c2\u6570\u6e90\u4fe1\u606f\u7684id\u914d\u7f6e\u91cd\u590d!\u8bf7\u67e5\u770b\uff0c\u91cd\u590d\u7684id\u4e3a:" + source.sourceID());
            }
            sources.put(source.sourceID(), this.sourceInfo.get(mark));
        }
    }

    private void volidateDeadLockExcuteOrder() {
        this.volidateRunAfterAnnotationMethodName();
        List methods = this.getTestClass().getAnnotatedMethods(RunAfter.class);
        HashMap<String, ArrayList<String>> orderInfo = new HashMap<String, ArrayList<String>>();
        ArrayList<Object> afterMethods = new ArrayList();
        for (FrameworkMethod method : methods) {
            String priorMethodName = ((RunAfter)method.getAnnotation(RunAfter.class)).methodName();
            afterMethods = orderInfo.get(priorMethodName) == null ? new ArrayList() : orderInfo.get(priorMethodName);
            afterMethods.add(method.getName());
            orderInfo.put(priorMethodName, afterMethods);
        }
        this.volidateDeadLock(orderInfo);
    }

    private void volidateDeadLock(HashMap<String, ArrayList<String>> orderInfo) {
        for (Map.Entry<String, ArrayList<String>> entry : orderInfo.entrySet()) {
            for (String next : entry.getValue()) {
                String deadLockPath = this.getDeadLockPath(entry.getKey(), next, orderInfo);
                if (deadLockPath == null) continue;
                throw new HolmosFailedError("\u65b9\u6cd5" + entry.getKey() + "()\u548c\u65b9\u6cd5" + next + "()\u5b58\u5728\u4e86\u8fd0\u884c\u987a\u5e8f\u6b7b\u9501,\u6b7b\u9501" + "\u60c5\u51b5\u5982\u4e0b:\n" + deadLockPath);
            }
        }
    }

    private String getDeadLockPath(String start, String end, HashMap<String, ArrayList<String>> orderInfo) {
        if (start.equalsIgnoreCase(end)) {
            return String.valueOf(start) + "->" + start + "->" + start;
        }
        String startToEnd = this.getReachablePath(start, end, orderInfo);
        String endToStart = this.getReachablePath(end, start, orderInfo);
        if (startToEnd != null && endToStart != null) {
            return String.valueOf(startToEnd) + endToStart.substring(endToStart.indexOf(45));
        }
        return null;
    }

    private String getReachablePath(String start, String end, HashMap<String, ArrayList<String>> orderInfo) {
        if (start.equalsIgnoreCase(end)) {
            return start;
        }
        ArrayList<String> nodes = orderInfo.get(start);
        if (nodes == null) {
            return null;
        }
        for (String node : nodes) {
            String pathTemp = this.getReachablePath(node, end, orderInfo);
            if (pathTemp == null) continue;
            return String.valueOf(start) + "->" + pathTemp;
        }
        return null;
    }

    private void volidateRunAfterAnnotationMethodName() {
        List methods = this.getTestClass().getAnnotatedMethods(RunAfter.class);
        for (FrameworkMethod method : methods) {
            this.volidateMethodInTestClass(method);
        }
    }

    private void volidateMethodInTestClass(FrameworkMethod method) {
        List allTestMethods = this.getTestClass().getAnnotatedMethods(Test.class);
        for (FrameworkMethod methodTemp : allTestMethods) {
            if (!methodTemp.getName().equalsIgnoreCase(method.getName())) continue;
            return;
        }
        throw new HolmosFailedError(String.valueOf(method.getName()) + "\u65b9\u6cd5\u91cc\u9762\u7684@RunAfer\u6ce8\u89e3\u91cc\u9762\u7684\u65b9\u6cd5\u540d\u5b57\u4e0d\u5728\u6b64\u6d4b\u8bd5\u7c7b\u6d4b\u8bd5\u65b9\u6cd5\u5217\u8868\u91cc\u9762!");
    }

    private String getValueOfSourceAnnotation(Source source) {
        if (source.file() == "" || source.file().equalsIgnoreCase("")) {
            return source.selector();
        }
        return source.file();
    }

    private void volidateValueOfSourceAnnotation(Source source) {
        int sourceCount = 0;
        if (!source.file().equalsIgnoreCase("")) {
            ++sourceCount;
        }
        if (!source.selector().equalsIgnoreCase("")) {
            ++sourceCount;
        }
        if (!source.className().equalsIgnoreCase("")) {
            ++sourceCount;
        }
        if (sourceCount >= 2) {
            throw new HolmosFailedError("\u5728\u4e00\u4e2a\u6570\u636e\u6e90\u914d\u7f6e\u91cc\u9762\u4e0d\u80fd\u540c\u65f6\u914d\u7f6e\u6570\u636e\u5e93\u548c\u6587\u4ef6\u4e24\u79cd\u7c7b\u578b!");
        }
        if (sourceCount == 0) {
            throw new HolmosFailedError("@Source\u6ca1\u6709\u914d\u7f6e\u6570\u636e\u6e90!");
        }
        if (source.sourceID() <= 0) {
            throw new HolmosFailedError("Holmos\u6846\u67b6\u4e0d\u5141\u8bb8\u53c2\u6570\u6e90\u7684id\u503c\u5c0f\u4e8e\u7b49\u4e8e0!\u8bf7\u8bbe\u7f6e\u53c2\u6570\u6e90\u7684id\u503c\u4e3a\u4e00\u4e2a\u6b63\u6570!");
        }
    }

    private ArrayList<Source> getSourceAnnotations() {
        ArrayList<Source> sources = new ArrayList<Source>();
        try {
            Source sourceOfClass = HolmosAnnotationUtils.getClassLevelAnnotation(this.getTestTarget().getClass(), Source.class);
            if (sourceOfClass != null) {
                sources.add(sourceOfClass);
            }
            sources.addAll(HolmosAnnotationUtils.getMethodLevelAnnotations(this.getTestTarget().getClass(), Source.class));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return sources;
    }

    private void initDataBaseConnections() {
        try {
            DataBase databaseOfClass = HolmosAnnotationUtils.getClassLevelAnnotation(this.getTestTarget().getClass(), DataBase.class);
            if (databaseOfClass != null) {
                this.connections.put(databaseOfClass.connectionName(), new ConnectionInfo(databaseOfClass));
            }
            for (DataBase database : HolmosAnnotationUtils.getMethodLevelAnnotations(this.getTestTarget().getClass(), DataBase.class)) {
                if (this.connections.get(database.connectionName()) != null) {
                    throw new HolmosFailedError("\u6570\u636e\u5e93\u8fde\u63a5\u7684\u540d\u5b57\u91cd\u590d\u4e86\uff0c\u8fd9\u4e2a\u91cd\u590d\u7684\u540d\u5b57\u4e3a:" + database.connectionName());
                }
                this.connections.put(database.connectionName(), new ConnectionInfo(database));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void validatePublicModiferWithAnnotation(Class<? extends Annotation> annotation) {
        List fields = this.getTestClass().getAnnotatedFields(annotation);
        for (FrameworkField field : fields) {
            if ((1 & field.getField().getModifiers()) != 0) continue;
            throw new HolmosFailedError(String.valueOf(field.getName()) + "\u7684\u4fee\u9970\u7b26\u4e0d\u662fpublic\u7c7b\u578b\uff0c\u7a0b\u5e8f\u5df2\u7ecf\u9000\u51fa\uff01Holmos\u6846\u67b6\u4e0d\u5141\u8bb8\u4e0d\u662fpublic\u7c7b\u578b\u7684\u6d4b\u8bd5\u65b9\u6cd5\u8fd0\u884c!");
        }
    }
}

