/*
 * Decompiled with CFR 0.152.
 */
package com.holmos.webtest.junitextentions.parameters;

import com.holmos.webtest.exceptions.HolmosFailedError;
import com.holmos.webtest.junitextentions.HolmosRunner;
import com.holmos.webtest.junitextentions.annotations.MultiThread;
import com.holmos.webtest.junitextentions.annotations.Parameter;
import com.holmos.webtest.junitextentions.annotations.RunCount;
import com.holmos.webtest.junitextentions.annotations.ValueAssert;
import com.holmos.webtest.junitextentions.annotations.ValueVerify;
import com.holmos.webtest.junitextentions.excute.ExcuteRunnable;
import com.holmos.webtest.junitextentions.excute.ExcuteThread;
import com.holmos.webtest.junitextentions.parameters.ParameterDataInfo;
import com.holmos.webtest.junitextentions.parameters.ParameterFrameWorkMethod;
import com.holmos.webtest.junitextentions.parameters.RunCountFrameWorkMethod;
import com.holmos.webtest.utils.HolmosAnnotationUtils;
import java.util.ArrayList;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.model.FrameworkMethod;

public class HolmosFrameWorkMethod {
    private ParameterDataInfo dataGetter;
    private boolean isMultiThread = false;
    private int runcount = 1;
    private int runcountThreadpoolSize = 1;
    private boolean isExecuted;
    private ArrayList<Object[]> parameters;
    private ArrayList<Object[]> resultValues;
    private int parameterThreadpoolSize = 1;
    private ArrayList<RunCountFrameWorkMethod> runCountFrameWorkMethods;
    private ArrayList<ParameterFrameWorkMethod> excuteFrameWorkMethods;
    private FrameworkMethod method;
    private ArrayList<HolmosFrameWorkMethod> successorMethods;
    private volatile int precursorMethodCount;
    private Object target;
    private RunNotifier notifier;

    public boolean isMultiThread() {
        return this.isMultiThread;
    }

    public int getRuncountThreadpoolSize() {
        return this.runcountThreadpoolSize;
    }

    public void setTarget(Object target) {
        this.target = target;
    }

    public void setNotifier(RunNotifier notifier) {
        this.notifier = notifier;
    }

    public FrameworkMethod getMethod() {
        return this.method;
    }

    public HolmosFrameWorkMethod(FrameworkMethod method) {
        this.method = method;
        this.isMultiThread = HolmosAnnotationUtils.hasClassOrMethodLevelAnnotation(HolmosRunner.getTestClassForGetter(), method.getMethod(), MultiThread.class);
        this.initRunCountInfo();
        this.initParameterInfo();
        this.initReturnValuesInfo();
        this.successorMethods = new ArrayList();
        this.precursorMethodCount = 0;
        this.isExecuted = false;
    }

    public void setGetter(ParameterDataInfo dataGetter) {
        this.dataGetter = dataGetter;
    }

    public ArrayList<RunCountFrameWorkMethod> getRunCountFrameWorkMethods() {
        if (this.runCountFrameWorkMethods == null) {
            this.runCountFrameWorkMethods = new ArrayList();
            int index = 0;
            while (index < this.runcount) {
                RunCountFrameWorkMethod runCountFrameWorkMethod = new RunCountFrameWorkMethod(this.method, index, this.parameters, this.resultValues, this.parameterThreadpoolSize);
                this.runCountFrameWorkMethods.add(runCountFrameWorkMethod);
                ++index;
            }
        }
        return this.runCountFrameWorkMethods;
    }

    public ArrayList<ParameterFrameWorkMethod> getExcuteFrameWorkMethods() {
        if (this.excuteFrameWorkMethods == null) {
            this.excuteFrameWorkMethods = new ArrayList();
            for (RunCountFrameWorkMethod runCountFrameWorkMethod : this.getRunCountFrameWorkMethods()) {
                this.excuteFrameWorkMethods.addAll(runCountFrameWorkMethod.getParameterFrameWorkMethods());
            }
        }
        return this.excuteFrameWorkMethods;
    }

    private void initParameterInfo() {
        Parameter parameter = (Parameter)this.method.getAnnotation(Parameter.class);
        if (parameter == null) {
            this.parameters = null;
            return;
        }
        this.dataGetter = HolmosRunner.sources.get(parameter.sourceID());
        if (this.dataGetter == null) {
            throw new HolmosFailedError("\u6ca1\u6709\u914d\u7f6esourceID\u4e3a" + parameter.sourceID() + "\u7684\u53c2\u6570\u6e90\u4fe1\u606f!\u51fa\u9519\u65b9\u6cd5\u4e3a:" + this.method.getName());
        }
        this.parameters = parameter.values() == null ? this.dataGetter.getAllParameters() : this.dataGetter.getParameters(parameter.values());
        this.parameterThreadpoolSize = parameter.threadPoolSize();
    }

    private void initReturnValuesInfo() {
        if (this.method.getAnnotation(ValueAssert.class) != null && this.method.getAnnotation(ValueVerify.class) != null) {
            throw new HolmosFailedError(String.valueOf(this.method.getName()) + "\u65b9\u6cd5\u4e0d\u80fd\u540c\u65f6\u542b\u6709Assert\u548cVerify\u4e24\u79cd\u4e0d\u540c\u7684\u6821\u9a8c\u65b9\u5f0f!");
        }
        if (this.method.getAnnotation(ValueAssert.class) != null) {
            this.initAssertRetrunValuesInfo();
        } else if (this.method.getAnnotation(ValueVerify.class) != null) {
            this.initVerifyReturnValuesInfo();
        } else {
            this.resultValues = null;
            return;
        }
        if (this.method.getMethod().getReturnType() != Void.TYPE) {
            if (this.parameters.size() != this.resultValues.size()) {
                throw new HolmosFailedError("\u6d4b\u8bd5\u65b9\u6cd5" + this.method.getName() + "\u8f93\u5165\u53c2\u6570\u7684\u7ec4\u6570\u548c\u5f85\u6821\u9a8c\u8fd4\u56de\u503c\u7684\u7ec4\u6570\u4e0d\u4e00\u81f4!");
            }
        } else if (this.resultValues.size() != 0) {
            throw new HolmosFailedError("\u6d4b\u8bd5\u65b9\u6cd5" + this.method.getName() + "\u7684\u8fd4\u56de\u503c\u7c7b\u578b\u4e3avoid,\u4e0d\u80fd\u4e3a\u5176\u914d\u7f6e\u6821\u9a8c\u503c\u4fe1\u606f!");
        }
    }

    private void initAssertRetrunValuesInfo() {
        ValueAssert valueAssert = (ValueAssert)this.method.getAnnotation(ValueAssert.class);
        if (valueAssert == null) {
            this.resultValues = null;
            return;
        }
        this.dataGetter = HolmosRunner.sources.get(valueAssert.sourceID());
        if (this.dataGetter == null) {
            throw new HolmosFailedError("\u6ca1\u6709\u914d\u7f6esourceID\u4e3a" + valueAssert.sourceID() + "\u7684\u53c2\u6570\u6e90\u4fe1\u606f!\u51fa\u9519\u65b9\u6cd5\u4e3a:" + this.method.getName());
        }
        this.resultValues = valueAssert.values() == null ? this.dataGetter.getAllParameters() : this.dataGetter.getParameters(valueAssert.values());
    }

    private void initVerifyReturnValuesInfo() {
        ValueVerify valueAssert = (ValueVerify)this.method.getAnnotation(ValueVerify.class);
        if (valueAssert == null) {
            this.resultValues = null;
            return;
        }
        this.dataGetter = HolmosRunner.sources.get(valueAssert.sourceID());
        if (this.dataGetter == null) {
            throw new HolmosFailedError("\u6ca1\u6709\u914d\u7f6esourceID\u4e3a" + valueAssert.sourceID() + "\u7684\u53c2\u6570\u6e90\u4fe1\u606f!\u51fa\u9519\u65b9\u6cd5\u4e3a:" + this.method.getName());
        }
        this.resultValues = valueAssert.values() == null ? this.dataGetter.getAllParameters() : this.dataGetter.getParameters(valueAssert.values());
    }

    private void initRunCountInfo() {
        RunCount count = (RunCount)this.method.getAnnotation(RunCount.class);
        if (count != null) {
            int n = this.runcount = count.runCount() <= 0 ? 1 : count.runCount();
            this.runcountThreadpoolSize = count.threadPoolSize() <= 0 ? 1 : (count.threadPoolSize() > this.runcount ? this.runcount : count.threadPoolSize());
        }
    }

    public void notifySuccessorMethods() {
        for (HolmosFrameWorkMethod method : this.successorMethods) {
            --method.precursorMethodCount;
            if (method.precursorMethodCount != 0) continue;
            try {
                method.invokeExplosively(this.target, this.notifier);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }

    public void addSuccessorMethods(HolmosFrameWorkMethod method) {
        this.successorMethods.add(method);
        ++method.precursorMethodCount;
    }

    public void invokeExplosively(Object target, RunNotifier notifier) throws Throwable {
        if (!this.isExecuted()) {
            if (this.isMultiThread) {
                new ExcuteThread(this, target, this.parameters, notifier).start();
            } else {
                new ExcuteRunnable(this, target, this.parameters, notifier).run();
            }
        }
    }

    public int getRuncount() {
        return this.runcount;
    }

    public boolean isExecuted() {
        return this.isExecuted;
    }

    public void setExecuted() {
        this.isExecuted = true;
    }

    public boolean hasPrecursorMethod() {
        return this.precursorMethodCount != 0;
    }
}

