/*
 * Decompiled with CFR 0.152.
 */
package com.holmos.webtest.junitextentions.parameters.excel;

import com.holmos.webtest.exceptions.HolmosFailedError;
import com.holmos.webtest.junitextentions.parameters.excel.HolmosRow;
import com.holmos.webtest.junitextentions.parameters.excel.HolmosSheet;
import com.holmos.webtest.junitextentions.parameters.excel.HolmosWorkBook;
import java.util.ArrayList;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;

public class HolmosExcelUtils {
    public static ArrayList<Integer> getFistColumnVlauesByFilePath(String excelFilePath) {
        HolmosWorkBook workBook = new HolmosWorkBook(excelFilePath);
        return HolmosExcelUtils.getFirstColumnValuesByWorkBook(workBook);
    }

    public static ArrayList<Integer> getFirstColumnValuesByWorkBook(HolmosWorkBook workBook) {
        return HolmosExcelUtils.getFirstColumnValuesByWorkBookAndIndex(workBook, 0);
    }

    public static ArrayList<Integer> getFirstColumnValuesByWorkBookAndIndex(HolmosWorkBook workBook, int sheetIndex) {
        ArrayList<Integer> firstColumnValues = new ArrayList();
        try {
            HolmosSheet sheet = workBook.getSheetByIndex(sheetIndex);
            firstColumnValues = HolmosExcelUtils.getFirstColumnBySheet(sheet);
        }
        catch (Exception e) {
            throw new HolmosFailedError("\u6307\u5b9a\u7684\u5217\u7d22\u5f15\u4e0d\u5b58\u5728");
        }
        return firstColumnValues;
    }

    public static ArrayList<Integer> getFirstColumnBySheet(HolmosSheet sheet) {
        return HolmosExcelUtils.getColumnValuesBySheetAndIndex(sheet, 0);
    }

    public static ArrayList<Integer> getColumnValuesBySheetAndIndex(HolmosSheet sheet, int columnIndex) {
        ArrayList<Integer> firstColumnValues = new ArrayList<Integer>();
        ArrayList<HolmosRow> rows = sheet.getValidRows();
        for (HolmosRow row : rows) {
            firstColumnValues.add(row.getCellByIndex(columnIndex).getValueAsInt());
        }
        if (firstColumnValues.size() > 0) {
            firstColumnValues.remove(0);
        }
        return firstColumnValues;
    }

    public static void writeInfoToExcel(ArrayList<ArrayList<String>> infos, String filePath) {
        HolmosWorkBook holmosBook = new HolmosWorkBook(filePath);
        Workbook workbook = holmosBook.getBook();
        Sheet sheet = workbook.createSheet();
        int i = 0;
        while (i < infos.size()) {
            Row row = sheet.createRow(i);
            int j = 0;
            while (j < infos.get(i).size()) {
                Cell cell = row.createCell(j, 1);
                cell.setCellValue(infos.get(i).get(j));
                ++j;
            }
            ++i;
        }
        holmosBook.saveFile(filePath);
    }
}

