/*
 * Decompiled with CFR 0.152.
 */
package com.holmos.webtest.junitextentions.parameters.excel;

import com.holmos.webtest.junitextentions.parameters.excel.HolmosRow;
import com.holmos.webtest.log.MyLogger;
import java.util.ArrayList;
import org.apache.poi.ss.usermodel.Sheet;

public class HolmosSheet {
    MyLogger logger = MyLogger.getLogger(HolmosSheet.class);
    private Sheet sheet;

    public HolmosSheet(Sheet sheet) {
        this.sheet = sheet;
    }

    public int getValidRowCount() {
        return this.sheet.getLastRowNum() - this.sheet.getFirstRowNum() + 1;
    }

    public ArrayList<HolmosRow> getValidRows() {
        ArrayList<HolmosRow> validRows = new ArrayList<HolmosRow>();
        int i = 0;
        while (i < this.getValidRowCount()) {
            validRows.add(new HolmosRow(this.sheet.getRow(i)));
            ++i;
        }
        return validRows;
    }

    public HolmosRow getRowByIndex(int index) {
        if (index < this.getValidRowCount()) {
            return new HolmosRow(this.sheet.getRow(index));
        }
        this.logger.error("\u8981\u83b7\u53d6\u7684\u6570\u636e\u884c\u4e0d\u5b58\u5728!");
        return null;
    }

    public void removeRowByIndex(int index) {
        if (index < this.getValidRowCount()) {
            this.sheet.removeRow(this.sheet.getRow(index));
        } else {
            this.logger.error("\u8981\u5220\u9664\u7684\u884c\u5728" + this.sheet.getSheetName() + "\u4e2d\u4e0d\u5b58\u5728!");
        }
    }
}

