/*
 * Decompiled with CFR 0.152.
 */
package com.holmos.webtest.utils;

import com.holmos.webtest.exceptions.HolmosFailedError;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class HolmosAnnotationUtils {
    public static <T extends Annotation> Set<Field> getFieldsWithAnnotationBase(Class<? extends Object> clazz, Class<T> annotationClass, boolean includeSuper) {
        if (Object.class.equals(clazz)) {
            return Collections.emptySet();
        }
        HashSet<Field> fieldsWithAnnotation = new HashSet<Field>();
        Field[] fieldArray = clazz.getDeclaredFields();
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            if (field.getAnnotation(annotationClass) != null) {
                fieldsWithAnnotation.add(field);
            }
            ++n2;
        }
        if (includeSuper) {
            fieldsWithAnnotation.addAll(HolmosAnnotationUtils.getFieldsWithAnnotationBase(clazz.getSuperclass(), annotationClass, includeSuper));
        }
        return fieldsWithAnnotation;
    }

    public static <T extends Annotation> Set<Field> getFieldsWithAnnotationIncludeSuper(Class<? extends Object> clazz, Class<T> annotationClass) {
        return HolmosAnnotationUtils.getFieldsWithAnnotationBase(clazz, annotationClass, true);
    }

    public static <T extends Annotation> Set<Field> getFieldsWithAnnotationNotIncludeSuper(Class<? extends Object> clazz, Class<T> annotationClass) {
        return HolmosAnnotationUtils.getFieldsWithAnnotationBase(clazz, annotationClass, false);
    }

    public static <T extends Annotation> Set<Method> getMethodsWithAnnotationBase(Class<? extends Object> clazz, Class<T> annotationClass, boolean includeSuper) {
        if (Object.class.equals(clazz)) {
            return Collections.emptySet();
        }
        HashSet<Method> methodsWithAnnotation = new HashSet<Method>();
        Method[] methodArray = clazz.getDeclaredMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            if (method.getAnnotation(annotationClass) != null) {
                methodsWithAnnotation.add(method);
            }
            ++n2;
        }
        if (includeSuper) {
            HolmosAnnotationUtils.getMethodsWithAnnotationBase(clazz.getSuperclass(), annotationClass, includeSuper);
        }
        return methodsWithAnnotation;
    }

    public static <T extends Annotation> Set<Method> getMethodsWithAnnotationIncludeSuper(Class<? extends Object> clazz, Class<T> annotationClass) {
        return HolmosAnnotationUtils.getMethodsWithAnnotationBase(clazz, annotationClass, true);
    }

    public static <T extends Annotation> Set<Method> getMethodsWithAnnotationNotIncludeSuper(Class<? extends Object> clazz, Class<T> annotationClass) {
        return HolmosAnnotationUtils.getMethodsWithAnnotationBase(clazz, annotationClass, false);
    }

    public static <T extends Annotation> ArrayList<T> getMethodLevelAnnotations(Class<?> clazz, Class<T> annotationClass) {
        ArrayList<T> result = new ArrayList<T>();
        Set<Method> methods = HolmosAnnotationUtils.getMethodsWithAnnotationIncludeSuper(clazz, annotationClass);
        for (Method method : methods) {
            result.add(method.getAnnotation(annotationClass));
        }
        return result;
    }

    public static <T extends Annotation> Set<T> getFieldLevelAnnotations(Class<?> clazz, Class<T> annotationClass) {
        HashSet<T> result = new HashSet<T>();
        Set<Field> fields = HolmosAnnotationUtils.getFieldsWithAnnotationIncludeSuper(clazz, annotationClass);
        for (Field field : fields) {
            result.add(field.getAnnotation(annotationClass));
        }
        return result;
    }

    public static <T extends Annotation> T getMethodOrClassLevelAnnotation(Class<?> clazz, Method method, Class<T> annotationClass) {
        T annotation = HolmosAnnotationUtils.getMethodLevelAnnotation(clazz, method, annotationClass);
        if (annotation != null) {
            return annotation;
        }
        annotation = HolmosAnnotationUtils.getClassLevelAnnotation(clazz, annotationClass);
        return annotation;
    }

    public static <S extends Annotation, T> T getMethodOrClassLevelAnnotationProperty(Class<S> annotationClass, String annotationPropertyName, T defaultValue, Method method, Class<?> clazz) {
        Method property;
        T propertyValue;
        S annotation = method.getAnnotation(annotationClass);
        if (annotation != null && !defaultValue.equals(propertyValue = HolmosAnnotationUtils.getAnnotationPropertyValue(property = HolmosAnnotationUtils.getPropertyByName(annotationPropertyName, annotationClass), annotation))) {
            return propertyValue;
        }
        return HolmosAnnotationUtils.getClassLevelAnnotationPropertyValue(clazz.getSuperclass(), annotationPropertyName, annotationClass, defaultValue);
    }

    private static Method getPropertyByName(String annotationPropertyName, Class<? extends Annotation> annotation) {
        try {
            return annotation.getMethod(annotationPropertyName, new Class[0]);
        }
        catch (SecurityException e) {
            throw new HolmosFailedError("\u6ce8\u89e3" + annotation.getName() + "\u83b7\u53d6" + annotationPropertyName + "\u5931\u8d25!");
        }
        catch (NoSuchMethodException e) {
            throw new HolmosFailedError("\u6ce8\u89e3" + annotation.getName() + "\u83b7\u53d6" + annotationPropertyName + "\u5931\u8d25!");
        }
    }

    public static <T extends Annotation> T getMethodLevelAnnotation(Class<?> clazz, Method method, Class<T> annotationClass) {
        if (Object.class.equals(clazz)) {
            return null;
        }
        return method.getAnnotation(annotationClass);
    }

    public static <T extends Annotation> T getClassLevelAnnotation(Class<?> clazz, Class<T> annotationClass) {
        if (Object.class.equals(clazz)) {
            return null;
        }
        T annotaion = clazz.getAnnotation(annotationClass);
        if (annotaion == null) {
            annotaion = HolmosAnnotationUtils.getClassLevelAnnotation(clazz.getSuperclass(), annotationClass);
        }
        return annotaion;
    }

    public static Method getAnnotationPropertyWithName(Class<? extends Annotation> annotation, String propertyName) {
        try {
            return annotation.getMethod(propertyName, new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new HolmosFailedError("\u5728" + annotation.getName() + "\u6ce8\u89e3\u91cc\u9762\u6ca1\u6709\u627e\u5230\u5c5e\u6027" + propertyName);
        }
    }

    public static <T> T getAnnotationPropertyValue(Method annotationProperty, Annotation annotation) {
        try {
            return (T)annotationProperty.invoke((Object)annotation, new Object[0]);
        }
        catch (IllegalArgumentException e) {
            throw new HolmosFailedError("\u65e0\u6cd5\u83b7\u5f97\u6ce8\u89e3" + annotation.annotationType().getName() + "\u7684" + annotationProperty.getName() + "\u5c5e\u6027\u4fe1\u606f!");
        }
        catch (IllegalAccessException e) {
            throw new HolmosFailedError("\u65e0\u6cd5\u83b7\u5f97\u6ce8\u89e3" + annotation.annotationType().getName() + "\u7684" + annotationProperty.getName() + "\u5c5e\u6027\u4fe1\u606f!");
        }
        catch (InvocationTargetException e) {
            throw new HolmosFailedError("\u65e0\u6cd5\u83b7\u5f97\u6ce8\u89e3" + annotation.annotationType().getName() + "\u7684" + annotationProperty.getName() + "\u5c5e\u6027\u4fe1\u606f!");
        }
    }

    public boolean hasFieldOrMethodOrClassLevelAnnotation(Class<? extends Object> clazz, Class<? extends Annotation> annotationClass) {
        return HolmosAnnotationUtils.getFieldLevelAnnotations(clazz, annotationClass).isEmpty() && HolmosAnnotationUtils.getMethodLevelAnnotations(clazz, annotationClass).isEmpty() && HolmosAnnotationUtils.getClassLevelAnnotation(clazz, annotationClass) != null;
    }

    public boolean hasFieldLevelAnnotation(Class<? extends Object> clazz, Class<? extends Annotation> annotationClass) {
        return HolmosAnnotationUtils.getFieldLevelAnnotations(clazz, annotationClass).isEmpty();
    }

    public boolean hasMethodLevelAnnotation(Class<? extends Object> clazz, Class<? extends Annotation> annotationClass) {
        return HolmosAnnotationUtils.getMethodLevelAnnotations(clazz, annotationClass).isEmpty();
    }

    public static boolean hasClassLevelAnnotation(Class<? extends Object> clazz, Class<? extends Annotation> annotationClass) {
        return HolmosAnnotationUtils.getClassLevelAnnotation(clazz, annotationClass) != null;
    }

    public static boolean hasClassOrMethodLevelAnnotation(Class<? extends Object> clazz, Method method, Class<? extends Annotation> annotationClass) {
        if (HolmosAnnotationUtils.hasClassLevelAnnotation(clazz, annotationClass)) {
            return true;
        }
        return HolmosAnnotationUtils.getMethodLevelAnnotation(clazz, method, annotationClass) != null;
    }

    public static <S extends Annotation, T> T getClassLevelAnnotationPropertyValue(Class<?> clazz, String propertyName, Class<S> annotationClass, T defaultValue) {
        Method annotationProperty;
        T propertyValue;
        if (Object.class.equals(clazz)) {
            return defaultValue;
        }
        S annotation = clazz.getAnnotation(annotationClass);
        if (annotation != null && (propertyValue = HolmosAnnotationUtils.getAnnotationPropertyValue(annotationProperty = HolmosAnnotationUtils.getAnnotationPropertyWithName(annotationClass, propertyName), annotation)).equals(defaultValue)) {
            return propertyValue;
        }
        return HolmosAnnotationUtils.getClassLevelAnnotationPropertyValue(clazz.getSuperclass(), propertyName, annotationClass, defaultValue);
    }

    public static <S extends Annotation, T> T getMethodLevelAnnotationPropertyValue(Method method, String propertyName, Class<S> annotationClass, T defaultValue) {
        S annotation = method.getAnnotation(annotationClass);
        Method annotationProperty = HolmosAnnotationUtils.getAnnotationPropertyWithName(annotationClass, propertyName);
        T propertyValue = HolmosAnnotationUtils.getAnnotationPropertyValue(annotationProperty, annotation);
        if (propertyValue == null) {
            return defaultValue;
        }
        return propertyValue;
    }

    public static <S extends Annotation, T> T getMethodOrClassLevelAnnotationPropertyValue(Class<?> clazz, Method method, String propertyName, Class<S> annotationClass, T defaultValue) {
        T propertyValue = HolmosAnnotationUtils.getMethodLevelAnnotationPropertyValue(method, propertyName, annotationClass, defaultValue);
        if (propertyName == null || propertyValue.equals(defaultValue)) {
            return HolmosAnnotationUtils.getClassLevelAnnotationPropertyValue(clazz, propertyName, annotationClass, defaultValue);
        }
        return propertyValue;
    }

    public static <T> T createInstanceOfType(Class<T> type, boolean bypassAccessibility, Class[] argumentTypes, Object[] arguments) {
        if (type.isMemberClass() || Modifier.isStatic(type.getModifiers())) {
            throw new HolmosFailedError("\u6210\u5458\u7c7b\u548c\u9759\u6001\u7c7b\u65e0\u6cd5\u4e3a\u5176\u6784\u9020\u5b9e\u4f8b!");
        }
        try {
            Constructor<T> constructor = type.getConstructor(argumentTypes);
            if (bypassAccessibility) {
                constructor.setAccessible(bypassAccessibility);
            }
            return constructor.newInstance(arguments);
        }
        catch (InvocationTargetException e) {
            throw new HolmosFailedError("\u6784\u9020" + type.getName() + "\u5b9e\u4f8b\u7684\u65f6\u5019\u53d1\u751f\u9519\u8bef!");
        }
        catch (Exception e) {
            throw new HolmosFailedError("\u6784\u9020" + type.getName() + "\u5b9e\u4f8b\u7684\u65f6\u5019\u53d1\u751f\u9519\u8bef!");
        }
    }
}

