/*
 * Decompiled with CFR 0.152.
 */
package com.holmos.webtest.utils;

import com.holmos.webtest.Allocator;
import com.holmos.webtest.constvalue.ConfigConstValue;
import com.holmos.webtest.constvalue.ConstValue;
import com.holmos.webtest.element.Element;
import com.holmos.webtest.exceptions.HolmosFailedError;
import com.holmos.webtest.struct.Collection;
import com.holmos.webtest.struct.Frame;
import com.holmos.webtest.struct.Page;
import com.holmos.webtest.struct.SubPage;
import com.holmos.webtest.utils.HolmosPropertiesUtils;
import com.holmos.webtest.utils.HolmosWindow;
import com.holmos.webtest.utils.file.MyFile;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.apache.log4j.PropertyConfigurator;

public class HolmosBaseUtils {
    public static void killProcess(String processName) {
        Runtime runTime = Runtime.getRuntime();
        try {
            runTime.exec("tskill " + processName);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void configLogProperties() {
        String logDirPath = HolmosBaseUtils.getLogDirPath();
        File file = new File(logDirPath);
        if (!file.exists()) {
            try {
                if (file.mkdirs()) {
                    new File(String.valueOf(logDirPath) + "\\log.log").createNewFile();
                    new File(String.valueOf(logDirPath) + "\\error.log").createNewFile();
                }
            }
            catch (Exception e1) {
                System.out.println("\u53d1\u73b0\u65e5\u5fd7\u6587\u4ef6\u4e0d\u5b58\u5728\uff0c\u4f46\u521b\u5efa\u6587\u4ef6\u5931\u8d25\uff01\u8bf7\u8054\u7cfb\u94f6\u9f99\uff01");
                e1.printStackTrace();
            }
        }
        PropertyConfigurator.configure((String)ConfigConstValue.LOGCONFIG);
    }

    private static String getLogDirPath() {
        Properties properties = new Properties();
        try {
            BufferedInputStream in = new BufferedInputStream(new FileInputStream(ConfigConstValue.HOLMOSCONFFILE));
            properties.load(in);
            return HolmosPropertiesUtils.getValue(properties, "logdir");
        }
        catch (ExceptionInInitializerError e) {
            System.out.println("\u914d\u7f6e\u6587\u4ef6\u6ca1\u6709\u52a0\u8f7d\u6210\u529f\uff0c\u68c0\u67e5\u914d\u7f6e\u6587\u4ef6\uff0c\u5e76\u5c06\u5176\u653e\u5165test\u4e0b\u9762\u7684resources\u76ee\u5f55\u4e0b\u9762,log\u6587\u4ef6\u7684\u9ed8\u8ba4\u4f4d\u7f6e\u5728C:\\holmos\\logs");
            return "C:\\holmos\\logs";
        }
        catch (IOException e) {
            System.out.println("\u914d\u7f6e\u6587\u4ef6\u6ca1\u6709\u52a0\u8f7d\u6210\u529f\uff0c\u68c0\u67e5\u914d\u7f6e\u6587\u4ef6\uff0c\u5e76\u5c06\u5176\u653e\u5165test\u4e0b\u9762\u7684resources\u76ee\u5f55\u4e0b\u9762,log\u6587\u4ef6\u7684\u9ed8\u8ba4\u4f4d\u7f6e\u5728C:\\holmos\\logs");
            return "C:\\holmos\\logs";
        }
    }

    public static void configScreenShotLocation() {
        String screenShotDir;
        ConstValue.screenShotDir = screenShotDir = HolmosBaseUtils.getScreenShotDirPath();
        File file = new File(screenShotDir);
        if (!file.exists()) {
            try {
                if (file.mkdirs()) {
                    System.out.println("\u622a\u5c4f\u5730\u5740\u521b\u5efa\u6210\u529f!");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static boolean isFileExist(String filePath) {
        return MyFile.exist(filePath);
    }

    public static String getScreenShotDirPath() {
        if (ConstValue.screenShotDir != null) {
            return ConstValue.screenShotDir;
        }
        Properties properties = new Properties();
        try {
            BufferedInputStream in = new BufferedInputStream(new FileInputStream(ConfigConstValue.HOLMOSCONFFILE));
            properties.load(in);
            ((InputStream)in).close();
            return HolmosPropertiesUtils.getValue(properties, "screenShotDir");
        }
        catch (IOException e) {
            throw new HolmosFailedError("holmos\u6846\u67b6\u914d\u7f6e\u6587\u4ef6\u627e\u4e0d\u5230!");
        }
    }

    public static void sleep(int miliSeconds) {
        try {
            Thread.sleep(miliSeconds);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    protected static String getClipboardText() throws Exception {
        Clipboard clip = Toolkit.getDefaultToolkit().getSystemClipboard();
        Transferable clipT = clip.getContents(null);
        if (clipT != null && clipT.isDataFlavorSupported(DataFlavor.stringFlavor)) {
            return (String)clipT.getTransferData(DataFlavor.stringFlavor);
        }
        return null;
    }

    protected static void setClipboardText(String writeMe) {
        Clipboard clip = Toolkit.getDefaultToolkit().getSystemClipboard();
        StringSelection tText = new StringSelection(writeMe);
        clip.setContents(tText, null);
    }

    public static Image getImageFromClipboard() throws Exception {
        Clipboard sysc = Toolkit.getDefaultToolkit().getSystemClipboard();
        Transferable cc = sysc.getContents(null);
        if (cc == null) {
            return null;
        }
        if (cc.isDataFlavorSupported(DataFlavor.imageFlavor)) {
            return (Image)cc.getTransferData(DataFlavor.imageFlavor);
        }
        return null;
    }

    protected static void setClipboardImage(final Image image) {
        Transferable trans = new Transferable(){

            @Override
            public DataFlavor[] getTransferDataFlavors() {
                return new DataFlavor[]{DataFlavor.imageFlavor};
            }

            @Override
            public boolean isDataFlavorSupported(DataFlavor flavor) {
                return DataFlavor.imageFlavor.equals(flavor);
            }

            @Override
            public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
                if (this.isDataFlavorSupported(flavor)) {
                    return image;
                }
                throw new UnsupportedFlavorException(flavor);
            }
        };
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(trans, null);
    }

    public static void openByTarget(String url, String target) {
        if (target == null) {
            Allocator.getInstance().currentWindow.open(url);
        } else if (target.equalsIgnoreCase("_blank")) {
            HolmosWindow.openNewWindow(url);
        } else if (target.equalsIgnoreCase("_self")) {
            Allocator.getInstance().currentWindow.open(url);
        }
    }

    public static void insertElementName(Element element, String name) {
        StringBuilder commentTemp = new StringBuilder(element.getComment());
        commentTemp.append("[" + name + "]");
        element.setComment(commentTemp.toString());
    }

    public static void insertSubPageName(SubPage subpage, String name) {
        StringBuilder commentTemp = new StringBuilder(subpage.getComment());
        commentTemp.append("[" + name + "]");
        subpage.setComment(commentTemp.toString());
    }

    public static void insertPageName(Page page, String name) {
        StringBuilder commentTemp = new StringBuilder(page.getComment());
        commentTemp.append("[" + name + "]");
        page.setComment(commentTemp.toString());
    }

    public static void insertFrameName(Frame frame, String name) {
        StringBuilder commentTemp = new StringBuilder(frame.getComment());
        commentTemp.append("[" + name + "]");
        frame.setComment(commentTemp.toString());
    }

    public static void insertCollectionName(Collection collection, String name) {
        StringBuilder commentTemp = new StringBuilder(collection.getComment(false));
        commentTemp.append("[" + name + "]");
        collection.setComment(commentTemp.toString());
    }
}

