/*
 * Decompiled with CFR 0.152.
 */
package com.holmos.webtest.utils;

import com.holmos.webtest.exceptions.HolmosFailedError;
import com.holmos.webtest.log.MyLogger;
import com.holmos.webtest.utils.HolmosBaseUtils;
import com.holmos.webtest.utils.HolmosPropertiesUtils;
import com.holmos.webtest.utils.HolmosReflectionUtils;
import java.util.Properties;

public class HolmosConfUtils {
    private static MyLogger logger = MyLogger.getLogger(HolmosConfUtils.class);

    public HolmosConfUtils() {
        HolmosBaseUtils.configLogProperties();
    }

    public static <T> T getInstanceOf(Class<T> type, Properties properties, String ... implementerValues) {
        String fullClassName = HolmosConfUtils.getImplementerName(type, properties, implementerValues);
        logger.info("\u521b\u5efa" + fullClassName + "\u5b9e\u4f8b");
        return HolmosReflectionUtils.createInstanceAsType(fullClassName, false);
    }

    private static String getImplementerName(Class<?> type, Properties properties, String[] implementerValues) {
        String propertyKey = String.valueOf(type.getName()) + ".impClassName";
        if (implementerValues != null) {
            String propertyKeyTemp = propertyKey;
            String[] stringArray = implementerValues;
            int n = implementerValues.length;
            int n2 = 0;
            while (n2 < n) {
                String implementerValue = stringArray[n2];
                propertyKeyTemp = String.valueOf(propertyKeyTemp) + "." + implementerValue;
                ++n2;
            }
            if (properties.contains(propertyKeyTemp)) {
                return HolmosPropertiesUtils.getValue(properties, propertyKeyTemp);
            }
        }
        if (properties.contains(propertyKey)) {
            return HolmosPropertiesUtils.getValue(properties, propertyKey);
        }
        throw new HolmosFailedError("\u627e\u4e0d\u5230" + propertyKey + "\u7684\u914d\u7f6e\u9879!");
    }
}

