/*
 * Decompiled with CFR 0.152.
 */
package com.holmos.webtest.utils;

import com.holmos.webtest.exceptions.HolmosFailedError;
import com.holmos.webtest.utils.file.MyString;
import java.util.ArrayList;

public class HolmosTypeCastUtils {
    public static Object getParameterEndByBlank(Object[] parameter) {
        ArrayList<String> parameterTemp = new ArrayList<String>();
        int i = 0;
        while (i < parameter.length) {
            if (((String)parameter[i]).equalsIgnoreCase("")) break;
            parameterTemp.add((String)parameter[i]);
            ++i;
        }
        return parameterTemp.toArray();
    }

    public static Object castObjectAsType(Class<?> type, Object obj) {
        if (((String)obj).equalsIgnoreCase("null")) {
            return HolmosTypeCastUtils.castNullObjectAsType(type, obj);
        }
        if (((String)obj).equalsIgnoreCase("\null")) {
            return HolmosTypeCastUtils.castNullStrObjectAsType(type, obj);
        }
        return HolmosTypeCastUtils.castNotNullObjectAsType(type, obj);
    }

    private static Object castNullStrObjectAsType(Class<?> type, Object obj) {
        MyString typeStr = new MyString(type.getName());
        if (typeStr.includeOr("java.lang.String")) {
            return "null";
        }
        throw new HolmosFailedError("\u5f53\u53c2\u6570\u5185\u5bb9\u4e3a'\null'\u7684\u65f6\u5019\uff0c\u53c2\u6570\u7c7b\u578b\u5fc5\u987b\u4e3a java.lang.String\u7c7b\u578b!");
    }

    private static Object castNullObjectAsType(Class<?> type, Object obj) {
        MyString typeStr = new MyString(type.getName());
        if (typeStr.includeOr("java.lang.String")) {
            return null;
        }
        if (typeStr.includeOr("java.lang.Byte", "byte")) {
            return 0;
        }
        if (typeStr.includeOr("java.lang.Integer", "int")) {
            return 0;
        }
        if (typeStr.includeOr("java.lang.Character", "char")) {
            return Character.valueOf('\u0000');
        }
        if (typeStr.includeOr("java.lang.Double", "double")) {
            return 0.0;
        }
        if (typeStr.includeOr("java.lang.Float", "float")) {
            return 0.0;
        }
        if (typeStr.includeOr("java.lang.Long", "long")) {
            return 0;
        }
        return null;
    }

    private static Object castNotNullObjectAsType(Class<?> type, Object obj) {
        MyString typeStr = new MyString(type.getName());
        if (obj == null) {
            throw new HolmosFailedError("\u53c2\u6570\u503c\u4e3anull!\u65e0\u6cd5\u5b8c\u6210\u8f6c\u6362!");
        }
        if (typeStr.includeOr("java.lang.String")) {
            return obj;
        }
        if (typeStr.includeOr("java.lang.Byte", "byte")) {
            return Byte.parseByte((String)obj);
        }
        if (typeStr.includeOr("java.lang.Integer", "int")) {
            return Integer.parseInt((String)obj);
        }
        if (typeStr.includeOr("java.lang.Character", "char")) {
            if (((String)obj).length() > 1) {
                throw new HolmosFailedError("\u5b57\u7b26\u7a9c\u957f\u5ea6\u5927\u4e8e1\uff0c\u65e0\u6cd5\u8f6c\u6362\u6210\u4e3a\u5b57\u7b26!");
            }
            return Character.valueOf(((String)obj).charAt(0));
        }
        if (typeStr.includeOr("java.lang.Double", "double")) {
            return Double.parseDouble((String)obj);
        }
        if (typeStr.includeOr("java.lang.Float", "float")) {
            return Float.valueOf(Float.parseFloat((String)obj));
        }
        if (typeStr.includeOr("java.lang.Long", "long")) {
            return Long.parseLong((String)obj);
        }
        return type.cast(obj);
    }
}

