/*
 * Decompiled with CFR 0.152.
 */
package com.holmos.webtest.utils.file;

import com.holmos.webtest.utils.file.MyString;
import com.holmos.webtest.utils.file.MyWriter;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;

public class MyFile {
    private String filePath;
    File file;

    public MyFile(String filePath) {
        this.filePath = filePath;
        this.file = new File(filePath);
        if (!this.file.exists()) {
            MyFile.createFile(filePath);
        }
    }

    public MyFile(File file) {
        this.filePath = file.getAbsolutePath();
        this.file = file;
    }

    public static boolean createDictory(String path) {
        if (!new File(path).exists()) {
            return new File(path).mkdirs();
        }
        return true;
    }

    public static boolean createFile(String path) {
        if (!new File(path).exists()) {
            StringBuilder dictoryPath = new StringBuilder(path);
            dictoryPath.delete(path.lastIndexOf(92), path.length());
            MyFile.createDictory(dictoryPath.toString());
            try {
                new File(path).createNewFile();
            }
            catch (IOException e) {
                System.out.println("\u6587\u4ef6\u521b\u5efa\u5931\u8d25!");
            }
        }
        return true;
    }

    public static boolean exist(String path) {
        return new File(path).exists();
    }

    public String getFileContentByString() {
        ArrayList<String> fileContentList = this.getFileContentByList();
        StringBuilder content = new StringBuilder();
        for (String str : fileContentList) {
            content.append(str);
        }
        return content.toString();
    }

    public ArrayList<String> getFileContentByList() {
        if (!new File(this.filePath).exists()) {
            return null;
        }
        ArrayList<String> fileContent = new ArrayList<String>();
        try {
            String temp;
            BufferedReader reader = new BufferedReader(new FileReader(new File(this.filePath)));
            while ((temp = reader.readLine()) != null) {
                fileContent.add(temp.trim());
            }
            reader.close();
            return fileContent;
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public void setFileContent(ArrayList<String> content) {
        MyWriter writer = new MyWriter(this.filePath);
        StringBuilder tab = new StringBuilder();
        int i = 0;
        while (i < content.size()) {
            MyString line = new MyString(content.get(i));
            if (line.includeAnd("}")) {
                tab.delete(0, 4);
            }
            writer.writeLine(tab.toString(), line.value);
            if (line.includeAnd("{")) {
                tab.append("    ");
            }
            ++i;
        }
        writer.flush();
        writer.close();
    }

    public static void deleteDirectory(String directoryPath) {
        File file = new File(directoryPath);
        if (file.isDirectory()) {
            String[] childsFile;
            File temp = null;
            String[] stringArray = childsFile = file.list();
            int n = childsFile.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                temp = directoryPath.endsWith(File.separator) ? new File(String.valueOf(directoryPath) + s) : new File(String.valueOf(directoryPath) + File.separator + s);
                if (temp != null && temp.isFile()) {
                    System.out.println(temp.delete());
                    System.out.println("delete of the fileName: " + temp.getAbsolutePath());
                } else if (temp != null && temp.isDirectory()) {
                    MyFile.deleteDirectory(temp.getAbsolutePath());
                }
                ++n2;
            }
            file.delete();
        } else if (file.isFile()) {
            file.delete();
        }
    }

    public boolean rename(String newName) {
        return this.file.renameTo(new File(String.valueOf(this.file.getParent()) + "\\" + newName));
    }
}

