/*
 * Decompiled with CFR 0.152.
 */
package com.ibatis.dao.engine.transaction.hibernate;

import com.ibatis.common.resources.Resources;
import com.ibatis.dao.client.DaoException;
import com.ibatis.dao.client.DaoTransaction;
import com.ibatis.dao.engine.transaction.DaoTransactionManager;
import com.ibatis.dao.engine.transaction.hibernate.HibernateDaoTransaction;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import net.sf.hibernate.SessionFactory;
import net.sf.hibernate.cfg.Configuration;

public class HibernateDaoTransactionManager
implements DaoTransactionManager {
    private SessionFactory factory;

    public void configure(Properties properties) {
        try {
            Configuration config = new Configuration();
            Iterator<Object> it = properties.keySet().iterator();
            while (it.hasNext()) {
                String key = (String)it.next();
                String value = (String)properties.get(key);
                if (key.startsWith("class.")) {
                    config.addClass(Resources.classForName((String)value));
                }
                if (!key.startsWith("map.")) continue;
                config.addResource(value);
            }
            Properties props = new Properties();
            props.putAll((Map<?, ?>)properties);
            config.setProperties(props);
            this.factory = config.buildSessionFactory();
        }
        catch (Exception e) {
            throw new DaoException("Error configuring Hibernate.  Cause: " + e);
        }
    }

    public DaoTransaction startTransaction() {
        return new HibernateDaoTransaction(this.factory);
    }

    public void commitTransaction(DaoTransaction trans) {
        ((HibernateDaoTransaction)trans).commit();
    }

    public void rollbackTransaction(DaoTransaction trans) {
        ((HibernateDaoTransaction)trans).rollback();
    }
}

