/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cos.spring.boot;

import com.ibm.cloud.objectstorage.ClientConfiguration;
import com.ibm.cloud.objectstorage.ClientConfigurationFactory;
import com.ibm.cloud.objectstorage.auth.AWSCredentials;
import com.ibm.cloud.objectstorage.auth.AWSCredentialsProvider;
import com.ibm.cloud.objectstorage.auth.AWSStaticCredentialsProvider;
import com.ibm.cloud.objectstorage.auth.BasicAWSCredentials;
import com.ibm.cloud.objectstorage.client.builder.AwsClientBuilder;
import com.ibm.cloud.objectstorage.oauth.BasicIBMOAuthCredentials;
import com.ibm.cloud.objectstorage.services.s3.AmazonS3;
import com.ibm.cloud.objectstorage.services.s3.AmazonS3ClientBuilder;
import com.ibm.cos.spring.boot.COSConfigurationProperties;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.SpringBootVersion;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={COSConfigurationProperties.class})
public class COSAutoConfiguration {
    @Autowired
    private COSConfigurationProperties config;

    @Bean
    @ConditionalOnMissingBean
    public AmazonS3ClientBuilder clientBuilder() {
        if (this.config.getEndpoint() == null) {
            throw new NullPointerException("endpoint must not be null");
        }
        return (AmazonS3ClientBuilder)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)AmazonS3ClientBuilder.standard().withEndpointConfiguration(new AwsClientBuilder.EndpointConfiguration(this.config.getEndpoint().toString(), this.config.getLocation()))).withCredentials((AWSCredentialsProvider)new AWSStaticCredentialsProvider(this.createAWSCredentials()))).withClientConfiguration(this.createClientConfig())).withPathStyleAccessEnabled(Boolean.valueOf(true));
    }

    private AWSCredentials createAWSCredentials() {
        if (this.config.getApiKey() != null) {
            return new BasicIBMOAuthCredentials(this.config.getApiKey(), this.config.getServiceInstanceId());
        }
        return new BasicAWSCredentials(this.config.getAccessKey(), this.config.getSecretKey());
    }

    private ClientConfiguration createClientConfig() {
        String suffix = String.format("spring_boot/%s", SpringBootVersion.getVersion());
        return new ClientConfigurationFactory().getConfig().withUserAgentSuffix(suffix);
    }

    @Bean
    @ConditionalOnMissingBean
    public AmazonS3 client(AmazonS3ClientBuilder builder) {
        return (AmazonS3)builder.build();
    }
}

