/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.objectstorage.waiters;

import com.ibm.cloud.objectstorage.AmazonServiceException;
import com.ibm.cloud.objectstorage.annotation.SdkInternalApi;
import com.ibm.cloud.objectstorage.util.ValidationUtils;
import com.ibm.cloud.objectstorage.waiters.WaiterAcceptor;
import com.ibm.cloud.objectstorage.waiters.WaiterState;
import java.util.ArrayList;
import java.util.List;

@SdkInternalApi
class CompositeAcceptor<Output> {
    private List<WaiterAcceptor<Output>> acceptors = new ArrayList<WaiterAcceptor<Output>>();

    public CompositeAcceptor(List<WaiterAcceptor<Output>> acceptors) {
        this.acceptors = ValidationUtils.assertNotEmpty(acceptors, "acceptors");
    }

    public List<WaiterAcceptor<Output>> getAcceptors() {
        return this.acceptors;
    }

    public WaiterState accepts(Output response) {
        for (WaiterAcceptor<Output> acceptor : this.acceptors) {
            if (!acceptor.matches(response)) continue;
            return acceptor.getState();
        }
        return WaiterState.RETRY;
    }

    public WaiterState accepts(AmazonServiceException exception) throws AmazonServiceException {
        for (WaiterAcceptor<Output> acceptor : this.acceptors) {
            if (!acceptor.matches(exception)) continue;
            return acceptor.getState();
        }
        throw exception;
    }
}

