/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.objectstorage.protocol.json;

import com.fasterxml.jackson.core.JsonFactory;
import com.ibm.cloud.objectstorage.http.JsonErrorResponseHandler;
import com.ibm.cloud.objectstorage.http.JsonResponseHandler;
import com.ibm.cloud.objectstorage.internal.http.ErrorCodeParser;
import com.ibm.cloud.objectstorage.internal.http.JsonErrorCodeParser;
import com.ibm.cloud.objectstorage.internal.http.JsonErrorMessageParser;
import com.ibm.cloud.objectstorage.protocol.json.JsonErrorResponseMetadata;
import com.ibm.cloud.objectstorage.protocol.json.JsonOperationMetadata;
import com.ibm.cloud.objectstorage.protocol.json.SdkStructuredJsonFactory;
import com.ibm.cloud.objectstorage.protocol.json.StructuredJsonGenerator;
import com.ibm.cloud.objectstorage.transform.JsonErrorUnmarshaller;
import com.ibm.cloud.objectstorage.transform.JsonUnmarshallerContext;
import com.ibm.cloud.objectstorage.transform.Unmarshaller;
import java.util.List;
import java.util.Map;

public abstract class SdkStructuredJsonFactoryImpl
implements SdkStructuredJsonFactory {
    private final JsonFactory jsonFactory;
    private final Map<Class<?>, Unmarshaller<?, JsonUnmarshallerContext>> unmarshallers;
    private final Map<JsonUnmarshallerContext.UnmarshallerType, Unmarshaller<?, JsonUnmarshallerContext>> customTypeUnmarshallers;

    public SdkStructuredJsonFactoryImpl(JsonFactory jsonFactory, Map<Class<?>, Unmarshaller<?, JsonUnmarshallerContext>> unmarshallers, Map<JsonUnmarshallerContext.UnmarshallerType, Unmarshaller<?, JsonUnmarshallerContext>> customTypeUnmarshallers) {
        this.jsonFactory = jsonFactory;
        this.unmarshallers = unmarshallers;
        this.customTypeUnmarshallers = customTypeUnmarshallers;
    }

    @Override
    public StructuredJsonGenerator createWriter(String contentType) {
        return this.createWriter(this.jsonFactory, contentType);
    }

    protected abstract StructuredJsonGenerator createWriter(JsonFactory var1, String var2);

    @Override
    public <T> JsonResponseHandler<T> createResponseHandler(JsonOperationMetadata operationMetadata, Unmarshaller<T, JsonUnmarshallerContext> responseUnmarshaller) {
        return new JsonResponseHandler<T>(responseUnmarshaller, this.unmarshallers, this.customTypeUnmarshallers, this.jsonFactory, operationMetadata.isHasStreamingSuccessResponse(), operationMetadata.isPayloadJson());
    }

    @Override
    public JsonErrorResponseHandler createErrorResponseHandler(JsonErrorResponseMetadata jsonErrorResponseMetadata, List<JsonErrorUnmarshaller> errorUnmarshallers) {
        boolean hasAwsQueryCompatible = jsonErrorResponseMetadata != null && jsonErrorResponseMetadata.getAwsQueryCompatible();
        String customErrorCodeFieldName = jsonErrorResponseMetadata != null ? jsonErrorResponseMetadata.getCustomErrorCodeFieldName() : null;
        return new JsonErrorResponseHandler(errorUnmarshallers, this.unmarshallers, this.customTypeUnmarshallers, this.getErrorCodeParser(customErrorCodeFieldName), hasAwsQueryCompatible, JsonErrorMessageParser.DEFAULT_ERROR_MESSAGE_PARSER, this.jsonFactory);
    }

    @Override
    public JsonErrorResponseHandler createErrorResponseHandler(List<JsonErrorUnmarshaller> errorUnmarshallers, String customErrorCodeFieldName) {
        return new JsonErrorResponseHandler(errorUnmarshallers, this.unmarshallers, this.customTypeUnmarshallers, this.getErrorCodeParser(customErrorCodeFieldName), JsonErrorMessageParser.DEFAULT_ERROR_MESSAGE_PARSER, this.jsonFactory);
    }

    protected ErrorCodeParser getErrorCodeParser(String customErrorCodeFieldName) {
        return new JsonErrorCodeParser(customErrorCodeFieldName);
    }
}

