/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.objectstorage.services.kms.model.transform;

import com.ibm.cloud.objectstorage.SdkClientException;
import com.ibm.cloud.objectstorage.annotation.SdkInternalApi;
import com.ibm.cloud.objectstorage.protocol.MarshallLocation;
import com.ibm.cloud.objectstorage.protocol.MarshallingInfo;
import com.ibm.cloud.objectstorage.protocol.MarshallingType;
import com.ibm.cloud.objectstorage.protocol.ProtocolMarshaller;
import com.ibm.cloud.objectstorage.protocol.StructuredPojo;
import com.ibm.cloud.objectstorage.services.kms.model.GrantListEntry;
import java.util.Date;
import java.util.List;

@SdkInternalApi
public class GrantListEntryMarshaller {
    private static final MarshallingInfo<String> KEYID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("KeyId").build();
    private static final MarshallingInfo<String> GRANTID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("GrantId").build();
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Name").build();
    private static final MarshallingInfo<Date> CREATIONDATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CreationDate").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<String> GRANTEEPRINCIPAL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("GranteePrincipal").build();
    private static final MarshallingInfo<String> RETIRINGPRINCIPAL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RetiringPrincipal").build();
    private static final MarshallingInfo<String> ISSUINGACCOUNT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("IssuingAccount").build();
    private static final MarshallingInfo<List> OPERATIONS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Operations").build();
    private static final MarshallingInfo<StructuredPojo> CONSTRAINTS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Constraints").build();
    private static final GrantListEntryMarshaller instance = new GrantListEntryMarshaller();

    public static GrantListEntryMarshaller getInstance() {
        return instance;
    }

    public void marshall(GrantListEntry grantListEntry, ProtocolMarshaller protocolMarshaller) {
        if (grantListEntry == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)grantListEntry.getKeyId(), KEYID_BINDING);
            protocolMarshaller.marshall((Object)grantListEntry.getGrantId(), GRANTID_BINDING);
            protocolMarshaller.marshall((Object)grantListEntry.getName(), NAME_BINDING);
            protocolMarshaller.marshall((Object)grantListEntry.getCreationDate(), CREATIONDATE_BINDING);
            protocolMarshaller.marshall((Object)grantListEntry.getGranteePrincipal(), GRANTEEPRINCIPAL_BINDING);
            protocolMarshaller.marshall((Object)grantListEntry.getRetiringPrincipal(), RETIRINGPRINCIPAL_BINDING);
            protocolMarshaller.marshall((Object)grantListEntry.getIssuingAccount(), ISSUINGACCOUNT_BINDING);
            protocolMarshaller.marshall(grantListEntry.getOperations(), OPERATIONS_BINDING);
            protocolMarshaller.marshall((Object)grantListEntry.getConstraints(), CONSTRAINTS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

