/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.jcc;

import com.ibm.db2.jcc.DB2Xml;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.sql.SQLException;

public class DB2ConnectionlessXml
implements DB2Xml {
    public byte[] xml_;
    boolean isClosed_;
    private static final String xmlStringDeclaration_ = "<?xml version=\"1.0\" encoding=\"ISO-10646-UCS-2\"?> ";
    private static final String xmlByteDeclarationPrefix_ = "<?xml version=\"1.0\" encoding=\"";
    private static final String xmlByteDeclarationPostfix_ = "\"?> ";

    public DB2ConnectionlessXml(byte[] byArray) {
        this.xml_ = byArray;
    }

    public byte[] getDB2Bytes() {
        return this.xml_;
    }

    public byte[] getDB2XmlBytes(String string) throws SQLException {
        return this.getDB2XmlBytesX(string);
    }

    public InputStream getDB2BinaryStream() {
        return new ByteArrayInputStream(this.xml_);
    }

    public InputStream getDB2XmlBinaryStream(String string) throws SQLException {
        return new ByteArrayInputStream(this.getDB2XmlBytesX(string));
    }

    public String getDB2String() throws SQLException {
        try {
            return new String(this.xml_, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new SQLException(unsupportedEncodingException.getMessage());
        }
    }

    public String getDB2XmlString() throws SQLException {
        return this.getDB2XmlStringX();
    }

    public Reader getDB2CharacterStream() throws SQLException {
        try {
            return new InputStreamReader((InputStream)new ByteArrayInputStream(this.xml_), "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new SQLException(unsupportedEncodingException.getMessage());
        }
    }

    public Reader getDB2XmlCharacterStream() throws SQLException {
        return new StringReader(this.getDB2XmlStringX());
    }

    public InputStream getDB2AsciiStream() {
        return new ByteArrayInputStream(this.xml_);
    }

    public InputStream getDB2XmlAsciiStream() throws SQLException {
        return new ByteArrayInputStream(this.getDB2XmlBytesX("ASCII"));
    }

    public void closeDB2Xml() {
        this.xml_ = null;
        this.isClosed_ = true;
    }

    public boolean isDB2XmlClosed() {
        return this.isClosed_;
    }

    private byte[] getDB2XmlBytesX(String string) throws SQLException {
        try {
            StringBuffer stringBuffer = new StringBuffer(xmlByteDeclarationPrefix_);
            stringBuffer.append(string);
            stringBuffer.append(xmlByteDeclarationPostfix_);
            byte[] byArray = stringBuffer.toString().getBytes(string);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byteArrayOutputStream.write(byArray);
            if ("UTF-8".equalsIgnoreCase(string)) {
                byteArrayOutputStream.write(this.xml_);
            } else {
                byteArrayOutputStream.write(new String(this.xml_, "UTF-8").getBytes(string));
            }
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            throw new SQLException(iOException.getMessage());
        }
    }

    private String getDB2XmlStringX() throws SQLException {
        try {
            return xmlStringDeclaration_ + new String(this.xml_, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new SQLException(unsupportedEncodingException.getMessage());
        }
    }
}

