/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.cmx.runtime.exception;

import com.ibm.db2.cmx.runtime.exception.ErrorType;
import com.ibm.db2.cmx.runtime.internal.StaticProfileConstants;
import java.sql.SQLException;

public class DataRuntimeException
extends RuntimeException {
    private static final long serialVersionUID = -4874351091795075279L;
    private DataRuntimeException nextException_;
    private final String rawMessage_;
    private final int exceptionLocation_;
    private String dataRuntimeExceptionMessage_;
    private String dataRuntimeExceptionMessageWithoutCausedBy_;
    protected final String productVersion_;
    protected static final String messageDelimiter_ = ";  ";
    private static final String productNameAbbreviation_ = "pdq";

    protected DataRuntimeException(String string, Throwable throwable, int n2, String string2) {
        super(throwable);
        this.rawMessage_ = StaticProfileConstants.maskJdbcURLPasswords(string);
        this.exceptionLocation_ = n2;
        this.productVersion_ = string2;
    }

    protected DataRuntimeException(String string, SQLException sQLException, int n2, String string2) {
        this(string, (Throwable)sQLException, n2, string2);
        if (null != sQLException) {
            sQLException.getMessage();
        }
    }

    @Override
    public String getMessage() {
        if (null == this.dataRuntimeExceptionMessage_ || null == this.dataRuntimeExceptionMessageWithoutCausedBy_) {
            String string;
            Throwable throwable = this.getCause();
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append('[').append(productNameAbbreviation_).append(']');
            stringBuilder.append('[').append(this.exceptionLocation_).append(']');
            stringBuilder.append('[').append(this.productVersion_).append(']');
            stringBuilder.append(' ');
            if (null != this.rawMessage_ && 0 < this.rawMessage_.length()) {
                stringBuilder.append(this.rawMessage_);
            }
            if (null != (string = this.getLocationInformation()) && 0 < string.length()) {
                stringBuilder.append(messageDelimiter_).append(string);
            }
            this.dataRuntimeExceptionMessageWithoutCausedBy_ = stringBuilder.toString();
            if (null != throwable) {
                stringBuilder.append(messageDelimiter_).append("Caused by: ");
                stringBuilder.append(this.getNameAndMessageOfCauseException(throwable));
            }
            this.dataRuntimeExceptionMessage_ = stringBuilder.toString();
        }
        return this.dataRuntimeExceptionMessage_;
    }

    public Integer getErrorCode() {
        Throwable throwable = this.getCause();
        if (null != throwable && throwable instanceof SQLException) {
            return ((SQLException)throwable).getErrorCode();
        }
        return -99999;
    }

    public String getSQLState() {
        Throwable throwable = this.getCause();
        if (null != throwable && throwable instanceof SQLException) {
            return ((SQLException)throwable).getSQLState();
        }
        return "FFFFF";
    }

    public boolean isTransient() {
        ErrorType errorType;
        Throwable throwable = this.getCause();
        return null != throwable && throwable instanceof SQLException && ((errorType = this.getErrorType()) == ErrorType.TIMEOUT_OR_DEADLOCK_WITH_ROLLBACK || errorType == ErrorType.TIMEOUT_OR_DEADLOCK_NO_ROLLBACK || errorType == ErrorType.RESOURCE_UNAVAILABLE);
    }

    public ErrorType getErrorType() {
        ErrorType errorType = null;
        Throwable throwable = this.getCause();
        if (null != throwable && throwable instanceof SQLException) {
            Integer n2 = this.getErrorCode();
            String string = this.getSQLState();
            String string2 = null != string ? string.substring(0, 2) : "FF";
            errorType = string2 == "08" ? ErrorType.CONNECTION_ERROR : (string2 == "0A" ? ErrorType.FEATURE_NOT_SUPPORTED : (string2 == "21" ? ErrorType.CARDINALITY_VIOLATION : (string2 == "23" ? (n2 == -803 ? ErrorType.DUPLICATE_ROW_VIOLATION : ErrorType.CONSTRAINT_VIOLATION) : (string2 == "24" ? ErrorType.INVALID_CURSOR_STATE : (string2 == "38" ? ErrorType.FUNCTION_ERROR : (string2 == "42" ? (string.substring(2) == "5" ? ErrorType.AUTHORIZATION_ERROR : ErrorType.SYNTAX_ERROR) : (string2 == "51" ? (n2 == -805 || n2 == -818 ? ErrorType.STATIC_PACKAGE_NOT_FOUND : ErrorType.UNCATEGORIZED_ERROR) : (string2 == "54" ? ErrorType.LIMIT_EXCEEDED : (string2 == "57" ? (n2 == -911 ? ErrorType.TIMEOUT_OR_DEADLOCK_WITH_ROLLBACK : (n2 == -913 ? ErrorType.TIMEOUT_OR_DEADLOCK_NO_ROLLBACK : ErrorType.RESOURCE_UNAVAILABLE)) : ErrorType.UNCATEGORIZED_ERROR)))))))));
        } else {
            errorType = ErrorType.UNCATEGORIZED_ERROR;
        }
        return errorType;
    }

    public int getExceptionLocation() {
        return this.exceptionLocation_;
    }

    public String getProductVersion() {
        return this.productVersion_;
    }

    protected String getDataRuntimeExceptionMessageWithoutCausedBy() {
        if (null == this.dataRuntimeExceptionMessageWithoutCausedBy_ || 0 < this.dataRuntimeExceptionMessageWithoutCausedBy_.length()) {
            this.getMessage();
        }
        return this.dataRuntimeExceptionMessageWithoutCausedBy_;
    }

    protected String getLocationInformation() {
        return null;
    }

    private String getNameAndMessageOfCauseException(Throwable throwable) {
        if (throwable instanceof DataRuntimeException) {
            DataRuntimeException dataRuntimeException = (DataRuntimeException)throwable;
            return dataRuntimeException.getClass().getName() + ": " + dataRuntimeException.getDataRuntimeExceptionMessageWithoutCausedBy();
        }
        return throwable.toString();
    }

    public DataRuntimeException getNextException() {
        return this.nextException_;
    }

    private void setNextException(DataRuntimeException dataRuntimeException) {
        this.nextException_ = dataRuntimeException;
    }

    public void addLastException(DataRuntimeException dataRuntimeException) {
        DataRuntimeException dataRuntimeException2 = this;
        DataRuntimeException dataRuntimeException3 = null;
        do {
            dataRuntimeException3 = dataRuntimeException2;
        } while ((dataRuntimeException2 = dataRuntimeException2.getNextException()) != null);
        dataRuntimeException3.setNextException(dataRuntimeException);
    }
}

