/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.spring.boot;

import com.ibm.mq.jms.MQConnectionFactory;
import com.ibm.mq.spring.boot.MQConfigurationProperties;
import com.ibm.mq.spring.boot.MQConnectionFactoryCustomizer;
import com.ibm.mq.spring.boot.MQConnectionFactoryFactory;
import java.util.List;
import javax.jms.ConnectionFactory;
import org.apache.commons.pool2.PooledObject;
import org.messaginghub.pooled.jms.JmsPoolConnectionFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.jms.JmsPoolConnectionFactoryProperties;
import org.springframework.boot.autoconfigure.jms.JmsProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.jms.connection.CachingConnectionFactory;

@Configuration
@ConditionalOnMissingBean(value={ConnectionFactory.class})
class MQConnectionFactoryConfiguration {
    MQConnectionFactoryConfiguration() {
    }

    private static MQConnectionFactory createConnectionFactory(MQConfigurationProperties properties, ObjectProvider<List<MQConnectionFactoryCustomizer>> factoryCustomizers) {
        return new MQConnectionFactoryFactory(properties, (List)factoryCustomizers.getIfAvailable()).createConnectionFactory(MQConnectionFactory.class);
    }

    @Configuration
    @ConditionalOnClass(value={JmsPoolConnectionFactory.class, PooledObject.class})
    static class PooledMQConnectionFactoryConfiguration {
        PooledMQConnectionFactoryConfiguration() {
        }

        @Bean(destroyMethod="stop")
        @ConditionalOnProperty(prefix="ibm.mq.pool", name={"enabled"}, havingValue="true", matchIfMissing=false)
        public JmsPoolConnectionFactory pooledJmsConnectionFactory(MQConfigurationProperties properties, ObjectProvider<List<MQConnectionFactoryCustomizer>> factoryCustomizers) {
            MQConnectionFactory connectionFactory = MQConnectionFactoryConfiguration.createConnectionFactory(properties, (ObjectProvider<List<MQConnectionFactoryCustomizer>>)factoryCustomizers);
            return this.create((ConnectionFactory)connectionFactory, properties.getPool());
        }

        private JmsPoolConnectionFactory create(ConnectionFactory connectionFactory, JmsPoolConnectionFactoryProperties poolProperties) {
            JmsPoolConnectionFactory pooledConnectionFactory = new JmsPoolConnectionFactory();
            pooledConnectionFactory.setConnectionFactory((Object)connectionFactory);
            pooledConnectionFactory.setBlockIfSessionPoolIsFull(poolProperties.isBlockIfFull());
            if (poolProperties.getBlockIfFullTimeout() != null) {
                pooledConnectionFactory.setBlockIfSessionPoolIsFullTimeout(poolProperties.getBlockIfFullTimeout().toMillis());
            }
            if (poolProperties.getIdleTimeout() != null) {
                pooledConnectionFactory.setConnectionIdleTimeout((int)poolProperties.getIdleTimeout().toMillis());
            }
            pooledConnectionFactory.setMaxConnections(poolProperties.getMaxConnections());
            pooledConnectionFactory.setMaxSessionsPerConnection(poolProperties.getMaxSessionsPerConnection());
            if (poolProperties.getTimeBetweenExpirationCheck() != null) {
                pooledConnectionFactory.setConnectionCheckInterval(poolProperties.getTimeBetweenExpirationCheck().toMillis());
            }
            pooledConnectionFactory.setUseAnonymousProducers(poolProperties.isUseAnonymousProducers());
            return pooledConnectionFactory;
        }
    }

    @Configuration
    @ConditionalOnClass(value={CachingConnectionFactory.class})
    @ConditionalOnProperty(prefix="ibm.mq.pool", name={"enabled"}, havingValue="false", matchIfMissing=true)
    static class RegularMQConnectionFactoryConfiguration {
        RegularMQConnectionFactoryConfiguration() {
        }

        @Bean
        @ConditionalOnProperty(prefix="spring.jms.cache", name={"enabled"}, havingValue="false")
        public MQConnectionFactory jmsConnectionFactory(MQConfigurationProperties properties, ObjectProvider<List<MQConnectionFactoryCustomizer>> factoryCustomizers) {
            return MQConnectionFactoryConfiguration.createConnectionFactory(properties, (ObjectProvider<List<MQConnectionFactoryCustomizer>>)factoryCustomizers);
        }

        @Bean
        @ConditionalOnProperty(prefix="spring.jms.cache", name={"enabled"}, havingValue="true", matchIfMissing=true)
        public CachingConnectionFactory cachingJmsConnectionFactory(MQConfigurationProperties properties, ObjectProvider<List<MQConnectionFactoryCustomizer>> factoryCustomizers, JmsProperties jmsProperties) {
            JmsProperties.Cache cacheProperties = jmsProperties.getCache();
            MQConnectionFactory wrappedConnectionFactory = MQConnectionFactoryConfiguration.createConnectionFactory(properties, (ObjectProvider<List<MQConnectionFactoryCustomizer>>)factoryCustomizers);
            CachingConnectionFactory connectionFactory = new CachingConnectionFactory((ConnectionFactory)wrappedConnectionFactory);
            connectionFactory.setCacheConsumers(cacheProperties.isConsumers());
            connectionFactory.setCacheProducers(cacheProperties.isProducers());
            connectionFactory.setSessionCacheSize(cacheProperties.getSessionCacheSize());
            return connectionFactory;
        }
    }
}

