/*
 * Decompiled with CFR 0.152.
 */
package com.icegreen.greenmail.util;

import com.icegreen.greenmail.AbstractServer;
import com.icegreen.greenmail.util.DummySSLSocketFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.mail.Folder;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Store;

public class Retriever {
    public static final String PROTOCOL_POP3 = "pop3";
    public static final String PROTOCOL_POP3S = "pop3s";
    public static final String PROTOCOL_IMAP = "imap";
    public static final String PROTOCOL_IMAPS = "imaps";
    private String protocol;
    private int port;
    private String host;
    private Store store = null;

    public Retriever(AbstractServer server) {
        this.protocol = server.getProtocol();
        this.port = server.getPort();
        this.host = server.getBindTo();
    }

    public Message[] getMessages(String account) throws Exception {
        return this.getMessages(account, account);
    }

    public Message[] getMessages(String account, String password) throws Exception {
        Properties props = new Properties();
        if (this.protocol.endsWith("s")) {
            props.put("mail.pop3.starttls.enable", Boolean.TRUE);
            props.put("mail.imap.starttls.enable", Boolean.TRUE);
        }
        props.setProperty("mail.imaps.socketFactory.class", DummySSLSocketFactory.class.getName());
        props.setProperty("mail.pop3s.socketFactory.class", DummySSLSocketFactory.class.getName());
        props.setProperty("mail.imap.socketFactory.fallback", "false");
        props.setProperty("mail.imaps.socketFactory.fallback", "false");
        props.setProperty("mail.pop3s.socketFactory.fallback", "false");
        String timeout = "15000";
        props.setProperty("mail.imap.connectiontimeout", "15000");
        props.setProperty("mail.imaps.connectiontimeout", "15000");
        props.setProperty("mail.pop3.connectiontimeout", "15000");
        props.setProperty("mail.pop3s.connectiontimeout", "15000");
        props.setProperty("mail.imap.timeout", "15000");
        props.setProperty("mail.imaps.timeout", "15000");
        props.setProperty("mail.pop3.timeout", "15000");
        props.setProperty("mail.pop3s.timeout", "15000");
        Session session = Session.getInstance((Properties)props, null);
        this.store = session.getStore(this.protocol);
        this.store.connect(this.host, this.port, account, password);
        Folder rootFolder = this.store.getFolder("INBOX");
        return this.getMessages(rootFolder).toArray(new Message[0]);
    }

    public void logout() {
        try {
            this.store.close();
        }
        catch (MessagingException e) {
            throw new RuntimeException(e);
        }
    }

    private List getMessages(Folder folder) throws MessagingException {
        int i;
        ArrayList<Message> ret = new ArrayList<Message>();
        if ((folder.getType() & 1) != 0) {
            if (!folder.isOpen()) {
                folder.open(1);
            }
            Message[] messages = folder.getMessages();
            for (i = 0; i < messages.length; ++i) {
                ret.add(messages[i]);
            }
        }
        if ((folder.getType() & 2) != 0) {
            Folder[] f = folder.list();
            for (i = 0; i < f.length; ++i) {
                ret.addAll(this.getMessages(f[i]));
            }
        }
        return ret;
    }
}

