/*
 * Decompiled with CFR 0.152.
 */
package com.icegreen.greenmail.foedus.util;

import java.io.IOException;
import java.io.Reader;
import java.io.Writer;

public class StreamUtils {
    protected StreamUtils() {
    }

    public static String toString(Reader in) throws IOException {
        int len;
        StringBuilder sbuf = new StringBuilder();
        char[] buffer = new char[1024];
        while ((len = in.read(buffer)) != -1) {
            sbuf.append(buffer, 0, len);
        }
        return sbuf.toString();
    }

    public static void copy(Reader in, Writer out) throws IOException {
        int len;
        char[] buffer = new char[1024];
        while ((len = in.read(buffer)) != -1) {
            out.write(buffer, 0, len);
        }
        in.close();
    }

    public static Reader limit(Reader in, long len) {
        return new LimitedReader(in, len);
    }

    public static Reader splice(Reader one, Reader two) {
        return new SpliceReader(one, two);
    }

    private static class LimitedReader
    extends Reader {
        Reader in;
        final long maxLen;
        long lenread;

        public LimitedReader(Reader in, long len) {
            this.in = in;
            this.maxLen = len;
        }

        @Override
        public void close() {
        }

        @Override
        public int read() throws IOException {
            if (this.lenread < this.maxLen) {
                ++this.lenread;
                return this.in.read();
            }
            return -1;
        }

        @Override
        public int read(char[] buf, int start, int len) throws IOException {
            if (this.lenread < this.maxLen) {
                int numAllowedToRead = (int)Math.min(this.maxLen - this.lenread, (long)len);
                int count = this.in.read(buf, start, numAllowedToRead);
                this.lenread += (long)count;
                return count;
            }
            return -1;
        }

        @Override
        public int read(char[] buf) throws IOException {
            return this.read(buf, 0, buf.length);
        }
    }

    private static class SpliceReader
    extends Reader {
        Reader one;
        Reader two;
        boolean oneFinished;

        public SpliceReader(Reader one, Reader two) {
            this.one = one;
            this.two = two;
        }

        @Override
        public void close() throws IOException {
            this.one.close();
            this.two.close();
        }

        @Override
        public int read() throws IOException {
            int value;
            while (true) {
                if (this.oneFinished) {
                    return this.two.read();
                }
                value = this.one.read();
                if (value != -1) break;
                this.oneFinished = true;
            }
            return value;
        }

        @Override
        public int read(char[] buf, int start, int len) throws IOException {
            int value;
            while (true) {
                if (this.oneFinished) {
                    return this.two.read(buf, start, len);
                }
                value = this.one.read(buf, start, len);
                if (value != -1) break;
                this.oneFinished = true;
            }
            return value;
        }

        @Override
        public int read(char[] buf) throws IOException {
            int value;
            while (true) {
                if (this.oneFinished) {
                    return this.two.read(buf);
                }
                value = this.one.read(buf);
                if (value != -1) break;
                this.oneFinished = true;
            }
            return value;
        }
    }
}

